/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.frameworkgui;

import java.util.Collection;
import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.frameworkgui.actions.AbstractFrameworkGUIAction;
import org.eclipse.viatra2.frameworkgui.actions.extend.ContributedActionContainer;
import org.eclipse.viatra2.frameworkgui.content.IFrameworkContentProviderExtension;
import org.eclipse.viatra2.frameworkgui.views.console.commands.IVIATRAConsoleCommandProviderFactory;
import org.eclipse.viatra2.frameworkgui.wizards.model.FileTemplateExtension;
import org.osgi.framework.BundleContext;

public class FrameworkGUIPlugin
extends AbstractUIPlugin {
    private static final String PLUGIN_ID = "org.eclipse.viatra2.gui";
    private static FrameworkGUIPlugin plugin;

    public FrameworkGUIPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static FrameworkGUIPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public Collection<IFrameworkContentProviderExtension> getContentProviders() {
        Vector<IFrameworkContentProviderExtension> v = new Vector<IFrameworkContentProviderExtension>();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint ep = reg.getExtensionPoint("org.eclipse.viatra2.gui.content");
        IExtension[] iExtensionArray = ep.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension e = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = e.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement ce = iConfigurationElementArray[n4];
                if (ce.getName().equalsIgnoreCase("content_provider")) {
                    try {
                        Object o = ce.createExecutableExtension("class");
                        if (o instanceof IFrameworkContentProviderExtension) {
                            v.add((IFrameworkContentProviderExtension)o);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return v;
    }

    public Collection<IVIATRAConsoleCommandProviderFactory> getCommandProviderFactories() {
        Vector<IVIATRAConsoleCommandProviderFactory> v = new Vector<IVIATRAConsoleCommandProviderFactory>();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint ep = reg.getExtensionPoint("org.eclipse.viatra2.gui.consoleCommandProvider");
        IExtension[] iExtensionArray = ep.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension e = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = e.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement ce = iConfigurationElementArray[n4];
                if (ce.getName().equalsIgnoreCase("commandProviderFactory")) {
                    try {
                        Object o = ce.createExecutableExtension("class");
                        if (o instanceof IVIATRAConsoleCommandProviderFactory) {
                            v.add((IVIATRAConsoleCommandProviderFactory)o);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return v;
    }

    public Collection<ContributedActionContainer> getContributedActions() {
        Vector<ContributedActionContainer> v = new Vector<ContributedActionContainer>();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint ep = reg.getExtensionPoint("org.eclipse.viatra2.gui.contributedAction");
        IExtension[] iExtensionArray = ep.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension e = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = e.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement ce = iConfigurationElementArray[n4];
                if (ce.getName().equalsIgnoreCase("contributedAction")) {
                    try {
                        Object o = ce.createExecutableExtension("class");
                        if (o instanceof AbstractFrameworkGUIAction) {
                            ContributedActionContainer c = new ContributedActionContainer();
                            c.action = (AbstractFrameworkGUIAction)((Object)o);
                            c.enablesFor = Class.forName(ce.getAttribute("enablesForType"));
                            v.add(c);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return v;
    }

    public Collection<FileTemplateExtension> getFileTemplates() {
        Vector<FileTemplateExtension> v = new Vector<FileTemplateExtension>();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint ep = reg.getExtensionPoint("org.eclipse.viatra2.gui.fileTemplate");
        IExtension[] iExtensionArray = ep.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension e = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = e.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement ce = iConfigurationElementArray[n4];
                if (ce.getName().equalsIgnoreCase("templateReference")) {
                    try {
                        FileTemplateExtension ext = new FileTemplateExtension();
                        ext.extension = ce.getAttribute("extension");
                        ext.name = ce.getAttribute("name");
                        ext.templateFile = ce.getAttribute("templateFile");
                        if (ce.getAttribute("description") != null) {
                            ext.desc = ce.getAttribute("description");
                        }
                        IConfigurationElement[] iConfigurationElementArray2 = ce.getChildren();
                        int n5 = iConfigurationElementArray2.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IConfigurationElement p = iConfigurationElementArray2[n6];
                            if (p.getName().equals("templateParameter")) {
                                FileTemplateExtension.TemplateParameter _p = new FileTemplateExtension.TemplateParameter(ext);
                                _p.name = p.getAttribute("name");
                                _p.value = _p.defaultValue = p.getAttribute("defaultValue");
                                if (p.getAttribute("description") != null) {
                                    _p.description = p.getAttribute("description");
                                }
                                ext.params.add(_p);
                            }
                            ++n6;
                        }
                        ext.contributorID = e.getNamespaceIdentifier();
                        v.add(ext);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return v;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow workBenchWindow = FrameworkGUIPlugin.getActiveWorkbenchWindow();
        if (workBenchWindow == null) {
            return null;
        }
        return workBenchWindow.getShell();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        if (plugin == null) {
            return null;
        }
        IWorkbench workBench = plugin.getWorkbench();
        if (workBench == null) {
            return null;
        }
        return workBench.getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow activeWorkbenchWindow = FrameworkGUIPlugin.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        return activeWorkbenchWindow.getActivePage();
    }

    public static String getPluginId() {
        return FrameworkGUIPlugin.getDefault().getBundle().getSymbolicName();
    }

    public static void log(Throwable e) {
        FrameworkGUIPlugin.log((IStatus)new Status(4, FrameworkGUIPlugin.getPluginId(), 4, "Error", e));
    }

    public static void log(IStatus status) {
        FrameworkGUIPlugin.getDefault().getLog().log(status);
    }

    public static void runAsLongTransaction(final IRunnableWithProgress r, final String taskName, final IFramework fw) {
        if (r != null) {
            final Display display = Display.getDefault();
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    ProgressMonitorDialog d = new ProgressMonitorDialog(display.getActiveShell());
                    try {
                        d.run(true, true, r);
                    }
                    catch (Exception e) {
                        if (fw != null) {
                            fw.getLogger().message(0, "Error executing task '" + taskName + "' (" + e.getClass().getCanonicalName() + ") [" + e.getMessage() + "]", (Throwable)e);
                        }
                        e.printStackTrace();
                    }
                }
            });
        }
    }
}

