/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.frameworkgui.views.console.commands.imports;

import java.io.File;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.frameworkgui.views.console.commands.IVIATRAConsoleCommandProvider;
import org.eclipse.viatra2.frameworkgui.views.console.commands.imports.NativeImporterCommands;

public class NativeImport
implements IVIATRAConsoleCommandProvider {
    @Override
    public void executeCommand(IFramework fw, List<String> parameters) {
        String ext;
        Set importerIDs;
        if (parameters.size() != 1) {
            fw.getLogger().error("[NativeImport] Wrong number of parameters supplied. Expected: 1, received: " + parameters.size());
            return;
        }
        String path = parameters.get(0);
        File f = null;
        IFile ifile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path));
        if (ifile.getLocation() == null) {
            f = new File(path);
            if (!f.exists()) {
                fw.getLogger().error("[NativeImport] file cannot be located");
                return;
            }
        } else {
            f = new File(ifile.getLocation().toOSString());
        }
        if ((importerIDs = fw.getNativeImportersForExtension(ext = path.substring(path.lastIndexOf(".") + 1))).size() < 1) {
            fw.getLogger().error("[NativeImport] No applicable native importer found for extension " + ext);
            return;
        }
        NativeImporterCommands.commenceImport(fw, f, (String)importerIDs.iterator().next());
    }

    @Override
    public String getCommandSignature() {
        return "nativeimport(filePath)";
    }

    @Override
    public String getDescription() {
        return "Imports the contents of a file into the VIATRA2 model space.";
    }

    @Override
    public String getHelpText() {
        return "Use nativeimport(<<filePath>>) with workspace-relative pathname (recommended) OR absolute file name.\nThis command " + this.getDescription();
    }
}

