/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.frameworkgui.wizards.ui;

import java.util.ArrayList;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.viatra2.frameworkgui.FrameworkGUIPlugin;
import org.eclipse.viatra2.frameworkgui.wizards.model.FileTemplateExtension;

public class TemplateSelectionPage
extends WizardPage {
    String extension;
    protected ListViewer templateList;
    protected TableViewer parameterTable;
    protected FileTemplateExtension template;

    public TemplateSelectionPage(String aKind) {
        super("Select a " + aKind.toUpperCase() + " template");
        this.extension = aKind;
    }

    public void createControl(Composite parent) {
        SashForm sash = new SashForm(parent, 2560);
        this.templateList = new ListViewer((Composite)sash, 4);
        this.templateList.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.templateList.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                ArrayList<FileTemplateExtension> r = new ArrayList<FileTemplateExtension>();
                for (FileTemplateExtension ex : FrameworkGUIPlugin.getDefault().getFileTemplates()) {
                    if (!ex.extension.toLowerCase().equals(TemplateSelectionPage.this.extension.toLowerCase())) continue;
                    r.add(ex);
                }
                return r.toArray();
            }
        });
        this.templateList.setInput((Object)FrameworkGUIPlugin.getDefault());
        this.templateList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object o;
                if (event.getSelection() instanceof IStructuredSelection && (o = ((IStructuredSelection)event.getSelection()).getFirstElement()) instanceof FileTemplateExtension) {
                    TemplateSelectionPage.this.template = (FileTemplateExtension)o;
                    TemplateSelectionPage.this.parameterTable.setInput((Object)TemplateSelectionPage.this.template);
                }
            }
        });
        this.parameterTable = new TableViewer((Composite)sash, -1);
        TableLayout tlay = new TableLayout();
        tlay.addColumnData((ColumnLayoutData)new ColumnWeightData(30, true));
        tlay.addColumnData((ColumnLayoutData)new ColumnWeightData(30, true));
        tlay.addColumnData((ColumnLayoutData)new ColumnWeightData(40, true));
        this.parameterTable.getTable().setLayout((Layout)tlay);
        TableColumn keyC = new TableColumn(this.parameterTable.getTable(), 16384);
        keyC.setText("Parameter name");
        TableColumn defvalC = new TableColumn(this.parameterTable.getTable(), 16384);
        defvalC.setText("Default Value");
        TableColumn valC = new TableColumn(this.parameterTable.getTable(), 16384);
        valC.setText("Actual Value");
        this.parameterTable.getTable().setHeaderVisible(true);
        this.parameterTable.getTable().setLinesVisible(true);
        this.parameterTable.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return ((FileTemplateExtension.TemplateParameter)element).name;
                    }
                    case 1: {
                        return ((FileTemplateExtension.TemplateParameter)element).defaultValue;
                    }
                }
                return ((FileTemplateExtension.TemplateParameter)element).value;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.parameterTable.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object element) {
                Object t = element;
                if (element instanceof IStructuredSelection) {
                    t = ((IStructuredSelection)element).getFirstElement();
                }
                if (t instanceof FileTemplateExtension) {
                    return ((FileTemplateExtension)t).params.toArray();
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.parameterTable.setCellEditors((CellEditor[])new TextCellEditor[]{new TextCellEditor((Composite)this.parameterTable.getTable()), new TextCellEditor((Composite)this.parameterTable.getTable()), new TextCellEditor((Composite)this.parameterTable.getTable())});
        this.parameterTable.setColumnProperties(new String[]{"name", "def", "value"});
        this.parameterTable.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return "value".equals(property);
            }

            public Object getValue(Object element, String property) {
                if ("value".equals(property)) {
                    return ((FileTemplateExtension.TemplateParameter)element).value;
                }
                return null;
            }

            public void modify(Object element, String property, Object value) {
                if ("value".equals(property)) {
                    FileTemplateExtension.TemplateParameter p = null;
                    p = element instanceof TableItem ? (FileTemplateExtension.TemplateParameter)((TableItem)element).getData() : (FileTemplateExtension.TemplateParameter)element;
                    TemplateSelectionPage.this.template.params.remove(p);
                    FileTemplateExtension.TemplateParameter _p = TemplateSelectionPage.this.template.new FileTemplateExtension.TemplateParameter();
                    _p.name = p.name;
                    _p.value = value.toString();
                    _p.defaultValue = p.defaultValue;
                    _p.description = p.description;
                    TemplateSelectionPage.this.template.params.add(_p);
                    TemplateSelectionPage.this.parameterTable.refresh();
                }
            }
        });
        this.setDescription("Select the template to use for the new file");
        sash.setWeights(new int[]{2, 1});
        this.setControl((Control)sash);
    }

    public boolean isPageComplete() {
        return this.template != null;
    }

    public FileTemplateExtension getSelectedTemplate() {
        return this.template;
    }
}

