/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.imports.vtml;

import org.eclipse.viatra2.core.EMultiplicityKind;
import org.eclipse.viatra2.core.IModelSpace;
import org.eclipse.viatra2.core.IRelation;
import org.eclipse.viatra2.errors.VPMCoreException;
import org.eclipse.viatra2.imports.vtml.ASTBuilder;
import org.eclipse.viatra2.imports.vtml.EntityDefinition;
import org.eclipse.viatra2.imports.vtml.RelationshipDefinition;

public class MultiplicityDefinition
extends RelationshipDefinition {
    String multiplicity = "";

    public MultiplicityDefinition(int l, String ns, String n, String s) {
        super(l, ns, n, null);
        this.multiplicity = s;
    }

    @Override
    public boolean checkDefintion(ASTBuilder ab, IModelSpace m) {
        boolean tmp = super.checkDefintion(ab, m);
        if (tmp && this._mstr instanceof EntityDefinition) {
            ab.log.error("Multiplicity can only be specified for relations. Error in line " + this.getLine());
            return false;
        }
        return tmp;
    }

    @Override
    public void resolveReferences(ASTBuilder ab) throws VPMCoreException {
        EMultiplicityKind mk = EMultiplicityKind.MANY_TO_MANY;
        if (this.multiplicity.equals("one_to_one")) {
            mk = EMultiplicityKind.ONE_TO_ONE;
        }
        if (this.multiplicity.equals("one_to_many")) {
            mk = EMultiplicityKind.ONE_TO_MANY;
        }
        if (this.multiplicity.equals("many_to_one")) {
            mk = EMultiplicityKind.MANY_TO_ONE;
        }
        ab.mm.setRelationMultiplicity((IRelation)this._mstr.getElement(), mk);
    }
}

