/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.visualisation;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.viatra2.visualisation.IVisualisationDescriptor;
import org.eclipse.zest.core.viewers.GraphViewer;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphConnection;
import org.eclipse.zest.core.widgets.GraphNode;

public class ViatraGraphViewer
extends GraphViewer {
    protected IVisualisationDescriptor descriptor;
    KeyAdapter keyListener = new KeyAdapter(){

        public void keyPressed(KeyEvent e) {
            if (e.keyCode == 127 || e.character == '\b') {
                ViatraGraphViewer.this.descriptor.removeSelection();
                ViatraGraphViewer.this.refresh();
            } else {
                super.keyPressed(e);
            }
        }
    };

    public ViatraGraphViewer(Composite composite, int style) {
        super(composite, style);
        this.graph.addKeyListener((KeyListener)this.keyListener);
    }

    public void setDescriptor(IVisualisationDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public void refresh() {
        super.refresh();
        this.styleConnections();
    }

    public void styleConnections() {
        Object[] objectArray = this.graph.getConnections().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object _conn = objectArray[n2];
            GraphConnection conn = (GraphConnection)_conn;
            GraphNode source = conn.getSource();
            GraphNode dest = conn.getDestination();
            LinkedList<GraphConnection> rightList = this.getConnectionList(source, dest);
            LinkedList<GraphConnection> leftList = null;
            if (dest != source) {
                leftList = this.getConnectionList(dest, source);
            }
            int size = leftList != null ? leftList.size() + rightList.size() : rightList.size();
            this.adjustCurves(rightList, size);
            if (leftList != null) {
                this.adjustCurves(leftList, size);
            }
            ++n2;
        }
    }

    private void adjustCurves(List<GraphConnection> connections, int size) {
        int i = 0;
        while (i < connections.size()) {
            GraphConnection conn = connections.get(i);
            int radius = 30;
            if (conn.getSource() == conn.getDestination()) {
                radius = 60;
            } else if (size < 2) {
                radius = 0;
            }
            conn.setCurveDepth((i + 1) * radius);
            ++i;
        }
    }

    private LinkedList<GraphConnection> getConnectionList(GraphNode source, GraphNode dest) {
        LinkedList<GraphConnection> list = new LinkedList<GraphConnection>();
        for (GraphConnection c : source.getSourceConnections()) {
            if (c.getDestination() != dest) continue;
            list.add(c);
        }
        return list;
    }

    public void saveImage(String filename, int format) {
        Graph g = (Graph)this.getControl();
        Rectangle bounds = g.getContents().getBounds();
        Point size = new Point(g.getContents().getSize().width, g.getContents().getSize().height);
        Point viewLocation = g.getViewport().getViewLocation();
        Image image = new Image(null, size.x, size.y);
        GC gc = new GC((Drawable)image);
        SWTGraphics swtGraphics = new SWTGraphics(gc);
        swtGraphics.translate(-1 * bounds.x + viewLocation.x, -1 * bounds.y + viewLocation.y);
        g.getViewport().paint((Graphics)swtGraphics);
        gc.copyArea(image, 0, 0);
        gc.dispose();
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{image.getImageData()};
        loader.save(filename, format);
    }
}

