/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.visualisation.modelspace.actions;

import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IModelManager;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.logger.Logger;
import org.eclipse.viatra2.treeeditor.actions.ViatraTreeEditorSelectionAction;
import org.eclipse.viatra2.visualisation.IVisualisationDescriptor;
import org.eclipse.viatra2.visualisation.modelspace.ModelSpaceVisualisationDescriptor;
import org.eclipse.viatra2.visualisation.view.ViatraVisualisationView;

public abstract class VisualiseSelectedElementAction
extends ViatraTreeEditorSelectionAction {
    public static final String ID_VIEW = "org.eclipse.viatra2.visualisation.view";
    ViatraVisualisationView view;
    ModelSpaceVisualisationDescriptor descriptor;

    public VisualiseSelectedElementAction() {
        this.setText("Graph Visualisation");
        this.setToolTipText("");
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_ELEMENTS"));
    }

    public VisualiseSelectedElementAction(IWorkbenchPart part) {
        super(part);
    }

    public void run() {
        List selectedObjects = this.getSelectedObjects().toList();
        IModelElement element = (IModelElement)selectedObjects.get(0);
        IFramework framework = element.getModelSpace().getFramework();
        Logger log = framework.getLogger();
        IModelManager manager = framework.getTopmodel().getModelManager();
        if (manager == null) {
            log.error("***The machine is not connected to a Model Space***");
            return;
        }
        this.view = ViatraVisualisationView.openView();
        IVisualisationDescriptor newDescriptor = this.view.getDescriptor(framework);
        if (newDescriptor == null || !(newDescriptor instanceof ModelSpaceVisualisationDescriptor)) {
            this.descriptor = new ModelSpaceVisualisationDescriptor();
            this.view.setDescriptor(framework, this.descriptor);
            this.descriptor.setFramework(framework);
            this.descriptor.setModelManager(manager);
        } else {
            this.descriptor = (ModelSpaceVisualisationDescriptor)newDescriptor;
            IModelManager oldManager = this.descriptor.getModelManager();
            if (oldManager != null && !manager.equals(oldManager)) {
                if (!MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"Graph overwrite", (String)"Another model space is already visualised. Do you want to overwrite it?")) {
                    return;
                }
                this.descriptor.setFramework(framework);
                this.descriptor.setModelManager(manager);
            } else if (oldManager == null) {
                this.descriptor.setFramework(framework);
                this.descriptor.setModelManager(manager);
            }
        }
        this.loadFilterData(this.view, selectedObjects);
        this.descriptor.redrawGraph();
    }

    public void updateSelf() {
        if (this.getSelectedObjects().size() != 1) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    abstract void loadFilterData(ViatraVisualisationView var1, List<IModelElement> var2);
}

