/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.visualisation.modelspace.actions.groups;

import java.util.HashSet;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.viatra2.visualisation.common.extensions.Category;
import org.eclipse.viatra2.visualisation.common.extensions.FilterConfiguration;
import org.eclipse.viatra2.visualisation.common.extensions.NamedElement;
import org.eclipse.viatra2.visualisation.common.extensions.internal.ExtensionAccess;
import org.eclipse.viatra2.visualisation.modelspace.actions.SelectFilterConfigurationAction;

public class CustomFilterGroup
extends ActionGroup {
    public void fillContextMenu(IMenuManager manager) {
        MenuManager menu = new MenuManager("Custom filter configurations");
        manager.add((IContributionItem)menu);
        HashSet<NamedElement<FilterConfiguration>> addedFilterConfigs = new HashSet<NamedElement<FilterConfiguration>>();
        for (Category c : ExtensionAccess.getAllCategories()) {
            MenuManager menuManager = new MenuManager(c.name);
            for (NamedElement<FilterConfiguration> fc_named : c.filterConfigurations.values()) {
                SelectFilterConfigurationAction action = new SelectFilterConfigurationAction(fc_named.name, (FilterConfiguration)fc_named.element);
                menuManager.add((IAction)action);
                addedFilterConfigs.add(fc_named);
            }
            menu.add((IContributionItem)menuManager);
        }
        HashSet<NamedElement<FilterConfiguration>> remaining = new HashSet<NamedElement<FilterConfiguration>>();
        remaining.addAll(ExtensionAccess.getAllFilterConfigurations());
        remaining.removeAll(addedFilterConfigs);
        if (!remaining.isEmpty()) {
            MenuManager unknowns = new MenuManager("Unspecified");
            for (NamedElement namedElement : remaining) {
                SelectFilterConfigurationAction action = new SelectFilterConfigurationAction(namedElement.name, (FilterConfiguration)namedElement.element);
                unknowns.add((IAction)action);
            }
            menu.add((IContributionItem)unknowns);
        }
    }
}

