/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.visualisation.modelspace.datasource.filter;

import java.util.Collection;
import org.eclipse.viatra2.core.IEntity;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IRelation;
import org.eclipse.viatra2.visualisation.modelspace.datasource.filter.FilterCondition;

public class PreFilter {
    private FilterCondition positiveConditions = new FilterCondition();
    private FilterCondition negativeConditions = new FilterCondition();

    private void includeRelationEnds(IRelation relation) {
        this.includeElement(relation.getFrom());
        this.includeElement(relation.getTo());
    }

    private void removeLinkedRelations(IModelElement element) {
        for (IModelElement relatedElement : element.getRelations()) {
            if (!(relatedElement instanceof IRelation) || this.isFiltered(relatedElement)) continue;
            IRelation relation = (IRelation)relatedElement;
            IModelElement from = relation.getFrom();
            IModelElement to = relation.getTo();
            if (!this.isFiltered(from) && !this.isFiltered(to)) continue;
            this.excludeElement((IModelElement)relation);
        }
    }

    public void includeElement(IModelElement element) {
        if (this.isFiltered(element)) {
            String name = element.getFullyQualifiedName();
            this.positiveConditions.addElementFilterCondition(name);
            this.negativeConditions.removeFilter(name, false);
        }
        if (element instanceof IRelation) {
            this.includeRelationEnds((IRelation)element);
        }
    }

    public void excludeElement(IModelElement element) {
        if (!this.isFiltered(element)) {
            String name = element.getFullyQualifiedName();
            if (element instanceof IEntity) {
                for (IModelElement subElement : ((IEntity)element).getContents()) {
                    if (this.isFiltered(subElement)) continue;
                    this.includeSubtree(subElement);
                }
            }
            this.negativeConditions.addElementFilterCondition(name);
            this.positiveConditions.removeFilter(name, false);
            this.removeLinkedRelations(element);
        }
    }

    public void includeSubtree(IModelElement element) {
        String name = element.getFullyQualifiedName();
        this.negativeConditions.removeFilter(name, true);
        this.positiveConditions.addSubtreeFilterCondition(name);
        if (element instanceof IRelation) {
            this.includeRelationEnds((IRelation)element);
        }
        for (IModelElement subElement : element.getAllElementsInNamespace()) {
            if (!(subElement instanceof IRelation)) continue;
            this.includeRelationEnds((IRelation)subElement);
        }
    }

    public void excludeSubtree(IModelElement element) {
        String name = element.getFullyQualifiedName();
        this.positiveConditions.removeFilter(name, true);
        this.negativeConditions.addSubtreeFilterCondition(name);
        this.removeLinkedRelations(element);
        for (IModelElement subElement : element.getAllElementsInNamespace()) {
            this.removeLinkedRelations(subElement);
        }
    }

    public boolean isFiltered(IModelElement element) {
        String name = element.getFullyQualifiedName();
        boolean negative = this.negativeConditions.isMatched(name);
        boolean positive = this.positiveConditions.isMatched(name);
        if (negative && positive) {
            boolean negElement = this.negativeConditions.elementContainsID(name);
            boolean posElement = this.positiveConditions.elementContainsID(name);
            if (negElement && posElement) {
                String posMatch = this.positiveConditions.getMostSpecificMatch(name);
                String negMatch = this.negativeConditions.getMostSpecificMatch(name);
                return posMatch.length() < negMatch.length();
            }
            return !posElement || negElement;
        }
        return !positive || negative;
    }

    public void removeDeletedElements(Collection<IModelElement> elements) {
        for (IModelElement element : elements) {
            String name = element.getFullyQualifiedName();
            if (name != null && this.positiveConditions.elementContainsID(name)) {
                this.positiveConditions.removeFilter(name, false);
            }
            if (name == null || !this.negativeConditions.elementContainsID(name)) continue;
            this.negativeConditions.removeFilter(name, false);
        }
    }
}

