/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.visualisation.patterns.sources;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Machine;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.GTPatternCall;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTPattern;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTPatternBody;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.PatternVariable;
import org.eclipse.viatra2.gtasmmodel.vpm.editmodel.Entity;
import org.eclipse.viatra2.gtasmmodel.vpm.editmodel.ModelElement;
import org.eclipse.viatra2.gtasmmodel.vpm.editmodel.Relation;
import org.eclipse.viatra2.visualisation.patterns.viewmodel.AbstractViewModelElement;
import org.eclipse.viatra2.visualisation.patterns.viewmodel.PatternTypes;
import org.eclipse.viatra2.visualisation.patterns.viewmodel.ViewParameterAssignment;
import org.eclipse.viatra2.visualisation.patterns.viewmodel.ViewPattern;
import org.eclipse.viatra2.visualisation.patterns.viewmodel.ViewPatternBody;
import org.eclipse.viatra2.visualisation.patterns.viewmodel.ViewPatternModelElement;
import org.eclipse.zest.core.viewers.IGraphEntityRelationshipContentProvider;
import org.eclipse.zest.core.viewers.INestedContentProvider;

public abstract class PatternContentProvider
implements IGraphEntityRelationshipContentProvider,
INestedContentProvider {
    Machine machine;
    GTPattern pattern;
    protected Hashtable<String, ViewPatternModelElement> viewItems = new Hashtable();

    List<ViewParameterAssignment> loadPatternParameters(ViewPattern pattern, ViewPatternModelElement element) {
        ArrayList<ViewParameterAssignment> relations = new ArrayList<ViewParameterAssignment>();
        for (String result : pattern.getParametersName(element)) {
            ViewParameterAssignment assignment = new ViewParameterAssignment();
            assignment.setParamName(result);
            assignment.setParameter(element);
            assignment.setPattern(pattern);
            relations.add(assignment);
        }
        return relations;
    }

    List<AbstractViewModelElement> loadRelationsBetween(ViewPatternModelElement element1, ViewPatternModelElement element2) {
        ArrayList<AbstractViewModelElement> relations = new ArrayList<AbstractViewModelElement>();
        Entity entity1 = (Entity)element1.getModelElement();
        Entity entity2 = (Entity)element2.getModelElement();
        for (Relation relation : entity1.getRelationsFrom()) {
            if (!relation.getTo().equals(entity2)) continue;
            ViewPatternModelElement viewRelation = new ViewPatternModelElement();
            viewRelation.setModelElement((ModelElement)relation);
            relations.add(viewRelation);
        }
        return relations;
    }

    public Object[] getElements(Object inputElement) {
        if (this.machine != null && this.pattern == null) {
            ArrayList<ViewPattern> patternList = new ArrayList<ViewPattern>();
            for (GTPattern pattern : this.machine.getGtPatternDefinitions()) {
                patternList.add(new ViewPattern(pattern, PatternTypes.CALLEDPATTERN));
            }
            return patternList.toArray();
        }
        if (this.pattern != null) {
            ArrayList<Object> elements = new ArrayList<Object>();
            int id = 1;
            for (GTPatternBody body : this.pattern.getPatternBodies()) {
                this.fillBody(body, id, elements);
                ++id;
            }
            return elements.toArray();
        }
        return null;
    }

    private void fillBody(GTPatternBody body, int id, List<Object> elements) {
        ViewPatternBody viewModel = new ViewPatternBody();
        viewModel.setBody(body);
        viewModel.setId(id);
        elements.add(viewModel);
        this.fillPatternGraph(body.getPatternGraph(), viewModel, elements);
        this.fillPatternCalls(viewModel, (EList<GTPatternCall>)body.getCalledPatterns(), elements, PatternTypes.CALLEDPATTERN);
        this.fillPatterns(viewModel, (EList<GTPattern>)body.getGtPatternDefinitions(), elements, PatternTypes.LOCALPATTERN);
        this.fillPatternCalls(viewModel, (EList<GTPatternCall>)body.getNegativePatterns(), elements, PatternTypes.NEGATIVEPATTERN);
    }

    abstract void fillPatternGraph(Entity var1, ViewPatternBody var2, List<Object> var3);

    void fillPatternCalls(ViewPatternBody body, EList<GTPatternCall> patternCalls, List<Object> elements, PatternTypes type) {
        for (GTPatternCall call : patternCalls) {
            this.fillPattern(body, elements, type, call.getCalledPattern());
        }
    }

    void fillPatterns(ViewPatternBody body, EList<GTPattern> patterns, List<Object> elements, PatternTypes type) {
        for (GTPattern pattern : patterns) {
            this.fillPattern(body, elements, type, pattern);
        }
    }

    private void fillPattern(ViewPatternBody body, List<Object> elements, PatternTypes type, GTPattern pattern) {
        ViewPattern viewPattern = new ViewPattern(pattern, type);
        for (PatternVariable symParam : pattern.getSymParameters()) {
            ViewPatternModelElement viewElement;
            EList patternElements = symParam.getElementInPattern();
            if (patternElements.isEmpty() || (viewElement = this.viewItems.get(((ModelElement)patternElements.get(0)).getName())) == null) continue;
            viewPattern.addParameter(symParam.getName(), viewElement);
        }
        body.addCalledPattern(viewPattern);
        elements.add(viewPattern);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof Machine) {
            this.machine = (Machine)newInput;
            this.pattern = null;
        } else if (newInput instanceof GTPattern) {
            this.pattern = (GTPattern)newInput;
        }
    }

    public Object[] getChildren(Object arg) {
        if (arg instanceof ViewPatternBody) {
            return ((ViewPatternBody)arg).getChildren();
        }
        return null;
    }

    public boolean hasChildren(Object arg) {
        return arg instanceof ViewPatternBody;
    }
}

