/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.visualisation.patterns.sources;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.viatra2.gtasmmodel.vpm.editmodel.Entity;
import org.eclipse.viatra2.gtasmmodel.vpm.editmodel.ModelElement;
import org.eclipse.viatra2.gtasmmodel.vpm.editmodel.Relation;
import org.eclipse.viatra2.visualisation.patterns.sources.PatternContentProvider;
import org.eclipse.viatra2.visualisation.patterns.viewmodel.AbstractViewModelElement;
import org.eclipse.viatra2.visualisation.patterns.viewmodel.PatternGraphArc;
import org.eclipse.viatra2.visualisation.patterns.viewmodel.ViewPattern;
import org.eclipse.viatra2.visualisation.patterns.viewmodel.ViewPatternBody;
import org.eclipse.viatra2.visualisation.patterns.viewmodel.ViewPatternModelElement;

public class PatternFullProvider
extends PatternContentProvider {
    @Override
    void fillPatternGraph(Entity patternGraph, ViewPatternBody body, List<Object> elements) {
        for (Entity entity : patternGraph.getComponents()) {
            ViewPatternModelElement element = new ViewPatternModelElement();
            element.setModelElement((ModelElement)entity);
            element.setBody(body);
            elements.add(element);
            body.addEntity(element);
            this.viewItems.put(entity.getName(), element);
            for (Relation relation : entity.getRelationsFrom()) {
                ViewPatternModelElement relationElement = new ViewPatternModelElement();
                relationElement.setModelElement((ModelElement)relation);
                relationElement.setBody(body);
                elements.add(relationElement);
                body.addEntity(relationElement);
                this.viewItems.put(relation.getName(), relationElement);
            }
        }
        System.out.println();
    }

    public Object[] getRelationships(Object source, Object dest) {
        ArrayList<AbstractViewModelElement> arcs = new ArrayList<AbstractViewModelElement>();
        if (source instanceof ViewPatternModelElement && dest instanceof ViewPatternModelElement) {
            ViewPatternModelElement src = (ViewPatternModelElement)source;
            ViewPatternModelElement dst = (ViewPatternModelElement)dest;
            if (src.isEntity() && dst.isRelation()) {
                if (src.getNumberOfRelationsFrom(dst) > 0) {
                    PatternGraphArc arc = new PatternGraphArc(src, dst);
                    arcs.add(arc);
                }
            } else if (src.isRelation() && dst.isEntity() && dst.getNumberOfRelationsTo(src) > 0) {
                PatternGraphArc arc = new PatternGraphArc(src, dst);
                arcs.add(arc);
            }
        } else if (source instanceof ViewPatternModelElement && dest instanceof ViewPattern) {
            arcs.addAll(this.loadPatternParameters((ViewPattern)dest, (ViewPatternModelElement)source));
        }
        return arcs.toArray();
    }
}

