/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.buffers;

import java.net.URISyntaxException;
import org.eclipse.viatra2.buffers.BufferStore;
import org.eclipse.viatra2.core.IModelSpace;
import org.eclipse.viatra2.errors.VPMRuntimeException;
import org.eclipse.viatra2.natives.ASMNativeFunction;
import org.eclipse.viatra2.natives.NativeFunctionParameter;
import org.eclipse.viatra2.natives.VIATRANativeFunction;

@VIATRANativeFunction(name="clearBuffer", remark="Clears an output buffer.", returns={NativeFunctionParameter.ParameterType.BOOLEAN}, params={@NativeFunctionParameter(description="Uniquely identifies an output buffer.Currently supported schemes are: core://<<id>>, file://<<workspace-relative path>>, os://<<absolute path>>.", name="bufferURI", type={NativeFunctionParameter.ParameterType.STRING})})
public class ClearBuffer
implements ASMNativeFunction {
    @Override
    public Object evaluate(IModelSpace msp, Object[] params) throws VPMRuntimeException {
        try {
            BufferStore.clearBuffer(msp, params[0].toString());
            return Boolean.TRUE;
        }
        catch (URISyntaxException e) {
            throw new VPMRuntimeException("Invalid URI syntax", e);
        }
    }

    @Override
    public String getDescription() {
        return "Clears a core:// output buffer";
    }

    @Override
    public String getID() {
        return this.getClass().getCanonicalName();
    }

    @Override
    public String getName() {
        return "clearBuffer";
    }
}

