/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.buffers;

import java.io.IOException;
import java.io.Writer;
import java.net.URISyntaxException;
import org.eclipse.viatra2.buffers.BufferStore;
import org.eclipse.viatra2.core.IModelSpace;
import org.eclipse.viatra2.errors.VPMRuntimeException;
import org.eclipse.viatra2.natives.ASMNativeFunction;
import org.eclipse.viatra2.natives.NativeFunctionParameter;
import org.eclipse.viatra2.natives.VIATRANativeFunction;

@VIATRANativeFunction(name="flushBuffer", remark="Flushes an output buffer.", returns={NativeFunctionParameter.ParameterType.BOOLEAN}, params={@NativeFunctionParameter(description="Uniquely identifies an output buffer.", name="bufferURI", type={NativeFunctionParameter.ParameterType.STRING})})
public class FlushBuffer
implements ASMNativeFunction {
    @Override
    public Object evaluate(IModelSpace msp, Object[] params) throws VPMRuntimeException {
        try {
            Writer w = BufferStore.getBuffer(msp, params[0].toString());
            w.flush();
            return Boolean.TRUE;
        }
        catch (URISyntaxException e) {
            throw new VPMRuntimeException("Invalid URI syntax", e);
        }
        catch (IOException e) {
            throw new VPMRuntimeException("Error while flushing buffer", e);
        }
    }

    @Override
    public String getDescription() {
        return "Flushes an output buffer";
    }

    @Override
    public String getID() {
        return this.getClass().getCanonicalName();
    }

    @Override
    public String getName() {
        return "flushBuffer";
    }
}

