/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.buffers;

import java.io.IOException;
import java.net.URISyntaxException;
import org.eclipse.viatra2.buffers.BufferStore;
import org.eclipse.viatra2.core.IModelSpace;
import org.eclipse.viatra2.errors.VPMRuntimeException;
import org.eclipse.viatra2.natives.ASMNativeFunction;
import org.eclipse.viatra2.natives.NativeFunctionParameter;
import org.eclipse.viatra2.natives.VIATRANativeFunction;

@VIATRANativeFunction(name="getBuffer", remark="If the buffer does not exist yet, it will be created. Existing files will be appended to.", returns={NativeFunctionParameter.ParameterType.NATIVE}, params={@NativeFunctionParameter(description="Uniquely identifies an output buffer. Currently supported schemes are: core://<<id>>, file://<<workspace-relative path>>, os://<<absolute path>>.", name="bufferURI", type={NativeFunctionParameter.ParameterType.STRING}), @NativeFunctionParameter(description="OPTIONALLY indicates whether a file:// or os:// buffer should be created by truncating the original file or append to", name="append", type={NativeFunctionParameter.ParameterType.BOOLEAN})})
public class GetBuffer
implements ASMNativeFunction {
    @Override
    public Object evaluate(IModelSpace msp, Object[] params) throws VPMRuntimeException {
        try {
            if (params.length > 1 && params[1] instanceof Boolean) {
                return BufferStore.getBuffer(msp, params[0].toString(), (Boolean)params[1]);
            }
            if (params.length == 1) {
                return BufferStore.getBuffer(msp, params[0].toString());
            }
        }
        catch (URISyntaxException e) {
            throw new VPMRuntimeException("Invalid URI syntax", e);
        }
        catch (IOException e) {
            throw new VPMRuntimeException("I/O error", e);
        }
        return null;
    }

    @Override
    public String getDescription() {
        return "Creates/retrieves a new output buffer";
    }

    @Override
    public String getID() {
        return this.getClass().getCanonicalName();
    }

    @Override
    public String getName() {
        return "getBuffer";
    }
}

