/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.core.tracebased.tracetree;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.viatra2.core.tracebased.tracetree.ITraceTreeNode;

public abstract class AbstractTraceTreeNode
implements ITraceTreeNode {
    private Map<String, ITraceTreeNode> children;
    private List<ITraceTreeNode> orderedChildren;
    private ITraceTreeNode parent;
    private String id;
    private boolean terminated = false;

    @Override
    public Map<String, ITraceTreeNode> getChildren() {
        if (this.children == null) {
            this.children = new TreeMap<String, ITraceTreeNode>();
            this.orderedChildren = new ArrayList<ITraceTreeNode>();
        }
        return this.children;
    }

    @Override
    public List<ITraceTreeNode> getOrderedChildrenList() {
        if (this.orderedChildren == null) {
            this.children = new TreeMap<String, ITraceTreeNode>();
            this.orderedChildren = new ArrayList<ITraceTreeNode>();
        }
        return this.orderedChildren;
    }

    @Override
    public void addChild(ITraceTreeNode child) {
        this.getChildren().put(child.getID(), child);
        this.getOrderedChildrenList().add(child);
    }

    @Override
    public Set<String> getChildrenIDs() {
        return this.getChildren().keySet();
    }

    @Override
    public ITraceTreeNode getChild(String childID) {
        return this.getChildren().get(childID);
    }

    @Override
    public String getID() {
        return this.id;
    }

    public AbstractTraceTreeNode(ITraceTreeNode parent, String id) {
        this.parent = parent;
        this.id = id;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    @Override
    public ITraceTreeNode getParent() {
        return this.parent;
    }

    public void setTerminated(boolean terminated) {
        this.terminated = terminated;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ID: ").append(this.id);
        if (this.parent != null) {
            sb.append("; Parent: ").append(this.parent.getID());
        }
        if (this.terminated) {
            sb.append("; Terminated");
        } else {
            sb.append("; In progress");
        }
        return sb.toString();
    }

    public List<ITraceTreeNode> getOrderedChildren() {
        return this.orderedChildren;
    }
}

