/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.errors.info;

public class Location {
    private int beginLine = 0;
    private int endLine = 0;
    private int beginColumn = 0;
    private int endColumn = 0;
    private int beginOffset = -1;
    private int endOffset = -1;

    public Location(int bl, int bc, int el, int ec) {
        this.beginLine = bl;
        this.endLine = el;
        this.beginColumn = bc;
        this.endColumn = ec;
    }

    public Location(int bl, int bc, int el, int ec, int bo, int eo) {
        this(bl, bc, el, ec);
        this.beginOffset = bo;
        this.endOffset = eo;
    }

    public Location(String locationStr) {
        String[] locations = locationStr.split(",");
        if (locations.length == 4) {
            this.beginLine = Location.parseInt(locations[0]);
            this.beginColumn = Location.parseInt(locations[1]);
            this.endLine = Location.parseInt(locations[2]);
            this.endColumn = Location.parseInt(locations[3]);
        }
    }

    public Location(String locationStr, String offsetStr) {
        this(locationStr);
        String[] offsets = offsetStr.split(":");
        if (offsets.length == 2) {
            this.beginOffset = Location.parseInt(offsets[0]);
            this.endOffset = Location.parseInt(offsets[1]);
        }
    }

    private static int parseInt(String s) {
        int i = -1;
        try {
            i = Integer.parseInt(s);
        }
        catch (Exception exception) {}
        return i;
    }

    public String toString() {
        return new String(String.valueOf(String.valueOf(this.beginLine)) + "," + String.valueOf(this.beginColumn) + "," + String.valueOf(this.endLine) + "," + String.valueOf(this.endColumn));
    }

    public int getBeginLine() {
        return this.beginLine;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getBeginColumn() {
        return this.beginColumn;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public int getBeginOffset() {
        return this.beginOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }
}

