/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.modelChecker.impl;

import java.util.TreeSet;
import org.eclipse.viatra2.core.IEntity;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IModelManager;
import org.eclipse.viatra2.core.IModelSpace;
import org.eclipse.viatra2.core.IRelation;

public class ConsistencyChecker {
    IModelSpace modelSpace;
    IModelManager mManager;
    TreeSet<IEntity> entities;
    TreeSet<IRelation> relations;
    TreeSet<IRelation> connections;
    TreeSet<IModelElement> elements;

    private ConsistencyChecker(IModelSpace ms) {
        this.modelSpace = ms;
        this.mManager = ms.getModelManager();
    }

    private boolean check() {
        this.entities = new TreeSet<IEntity>(this.mManager.getEntities());
        this.relations = new TreeSet<IRelation>(this.mManager.getRelations());
        this.connections = new TreeSet();
        this.connections.addAll(this.relations);
        this.elements = new TreeSet();
        this.elements.addAll(this.entities);
        this.elements.addAll(this.relations);
        this.checkHasParent();
        this.checkAllRelations();
        this.checkAllTypes();
        return true;
    }

    private boolean checkHasParent() {
        for (IModelElement me : this.elements) {
            if (!(me instanceof IEntity)) continue;
            IEntity ent = (IEntity)me;
            if (!ent.equals(this.mManager.getRoot())) {
                if (ent.getParent() == null) {
                    throw new RuntimeException("Not consistent!!!" + ent.getName() + " has no parent");
                }
                IEntity parent = ent.getParent();
                if (!this.elements.contains(parent)) {
                    throw new RuntimeException("Not consistent!!!");
                }
                if (!parent.getContents().contains(me)) {
                    throw new RuntimeException("Not consistent!!!");
                }
            }
            if (ent.getContents().size() == 0) continue;
            for (IEntity iEntity : ent.getContents()) {
                if (!this.elements.contains(iEntity)) {
                    throw new RuntimeException("Not consistent!!!");
                }
                if (iEntity.getParent().equals(ent)) continue;
                throw new RuntimeException("Not consistent!!!");
            }
        }
        return true;
    }

    private boolean checkAllRelations() {
        for (IEntity ent : this.entities) {
            for (IRelation rel : ent.getRelationsFrom()) {
                if (!this.elements.contains(rel)) {
                    throw new RuntimeException("not consistent!!!");
                }
                if (rel.getFrom() == ent) continue;
                throw new RuntimeException("not consistent!!!");
            }
            for (IRelation rel : ent.getRelationsTo()) {
                if (!this.elements.contains(rel)) {
                    throw new RuntimeException("not consistent!!!");
                }
                if (rel.getTo() == ent) continue;
                throw new RuntimeException("not consistent!!!");
            }
        }
        for (IRelation r : this.relations) {
            if (!r.getFrom().getRelationsFrom().contains(r)) {
                throw new RuntimeException("Error");
            }
            if (r.getTo().getRelationsTo().contains(r)) continue;
            System.out.println(r.getFullyQualifiedName());
            for (IModelElement iModelElement : r.getTo().getRelationsTo()) {
                System.out.println(iModelElement.getFullyQualifiedName());
            }
            throw new RuntimeException("Error");
        }
        return true;
    }

    private boolean checkAllTypes() {
        for (IModelElement elem : this.elements) {
            for (IModelElement rel : elem.getInstances()) {
                if (!this.elements.contains(rel)) {
                    throw new RuntimeException("not consistent!!!");
                }
                if (rel.getTypes().contains(elem)) continue;
                throw new RuntimeException("not consistent!!!");
            }
            for (IModelElement rel : elem.getTypes()) {
                if (!this.elements.contains(rel)) {
                    throw new RuntimeException("not consistent!!!");
                }
                if (rel.getInstances().contains(elem)) continue;
                throw new RuntimeException("not consistent!!!");
            }
            for (IModelElement rel : elem.getSubtypes()) {
                if (!this.elements.contains(rel)) {
                    throw new RuntimeException("not consistent!!!");
                }
                if (rel.getSupertypes().contains(elem)) continue;
                throw new RuntimeException("not consistent!!!");
            }
            for (IModelElement rel : elem.getSupertypes()) {
                if (!this.elements.contains(rel)) {
                    throw new RuntimeException("not consistent!!!");
                }
                if (rel.getSubtypes().contains(elem)) continue;
                throw new RuntimeException("not consistent!!!");
            }
        }
        return true;
    }

    public static void check(IModelSpace ms) {
        ConsistencyChecker ch = new ConsistencyChecker(ms);
        ch.check();
    }
}

