/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.treeeditor.actions;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IRelation;
import org.eclipse.viatra2.treeeditor.Plugin;
import org.eclipse.viatra2.treeeditor.ViatraTreeEditor;
import org.eclipse.viatra2.treeeditor.actions.ViatraTreeEditorSelectionAction;

public class NavigateRelationAction
extends ViatraTreeEditorSelectionAction {
    public static final String ID = "ViatraTreeEditor.Actions.NavigateRelationAction";

    public NavigateRelationAction(IWorkbenchPart part) {
        super(part);
        this.setText("Navigate to target");
        this.setToolTipText("Reveal and select the target of this relation.");
        this.setImageDescriptor(Plugin.getImageDescriptor("icons/relation_transparent.png"));
    }

    public void run() {
        final IRelation source = (IRelation)this.getSelectedObjects().toList().get(0);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    ((ViatraTreeEditor)NavigateRelationAction.this.iPart).getTreeViewer().reveal((Object)source.getTo());
                    ((ViatraTreeEditor)NavigateRelationAction.this.iPart).getTreeViewer().setSelection((ISelection)new StructuredSelection(new Object[]{source.getTo()}));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public void updateSelf() {
        if (this.getSelectedObjects().size() == 1 && this.getSelectedObjects().getFirstElement() instanceof IModelElement) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }
}

