/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.treeeditor.commands;

import org.eclipse.viatra2.core.IEntity;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IRelation;
import org.eclipse.viatra2.errors.VPMCoreException;
import org.eclipse.viatra2.treeeditor.commands.ViatraEditorCommand;

public class MoveModelElementCommand
extends ViatraEditorCommand {
    private IEntity newparent;
    private IEntity oldparent;
    private IEntity child;
    private String newparent_name;
    private String oldparent_name;
    private String child_name;
    private String child_oldname;
    private IModelElement newsource;
    private IModelElement oldsource;
    private IRelation relation;
    private String newsource_name;
    private String oldsource_name;
    private String relation_name;
    private String relation_oldname;

    public void setEntity(IEntity aChld, IEntity aNewParent) {
        this.child = aChld;
        this.oldparent = this.child.getParent();
        this.newparent = aNewParent;
        this.child_name = this.child.getFullyQualifiedName();
        this.oldparent_name = this.oldparent.getFullyQualifiedName();
        this.newparent_name = this.newparent.getFullyQualifiedName();
        this.relation = null;
        this.oldsource = null;
        this.newsource = null;
        this.relation_oldname = null;
        this.relation_name = null;
        this.oldsource_name = null;
        this.newsource_name = null;
    }

    public void setRelation(IRelation aRel, IModelElement aNewSource) {
        this.relation = aRel;
        this.oldsource = this.relation.getFrom();
        this.newsource = aNewSource;
        this.relation_name = this.relation.getFullyQualifiedName();
        this.oldsource_name = this.oldsource.getFullyQualifiedName();
        this.newsource_name = this.newsource.getFullyQualifiedName();
        this.child = null;
        this.oldparent = null;
        this.newparent = null;
        this.child_oldname = null;
        this.child_name = null;
        this.oldparent_name = null;
        this.newparent_name = null;
    }

    @Override
    public void execute() throws VPMCoreException {
        this.newparent = (IEntity)this.Lookup((IModelElement)this.newparent, this.newparent_name);
        this.oldparent = (IEntity)this.Lookup((IModelElement)this.oldparent, this.oldparent_name);
        this.child = (IEntity)this.Lookup((IModelElement)this.child, this.child_name);
        this.newsource = this.Lookup(this.newsource, this.newsource_name);
        this.oldsource = this.Lookup(this.oldsource, this.oldsource_name);
        this.relation = (IRelation)this.Lookup((IModelElement)this.relation, this.relation_name);
        if (this.child != null && this.oldparent != null && this.newparent != null) {
            this.iTransactionID = this.child.getModelSpace().getTransactionManager().beginUndoableTransaction();
            this.child.getModelSpace().getModelManager().moveEntityTo(this.child, this.newparent);
            this.child_oldname = this.child_name;
            this.child_name = this.child.getFullyQualifiedName();
            this.child.getModelSpace().getTransactionManager().commitTransaction();
        } else if (this.relation != null && this.oldsource != null && this.newsource != null) {
            this.iTransactionID = this.relation.getModelSpace().getTransactionManager().beginUndoableTransaction();
            this.relation.getModelSpace().getModelManager().setRelationFrom(this.relation, this.newsource);
            this.relation_oldname = this.relation_name;
            this.relation_name = this.relation.getFullyQualifiedName();
            this.relation.getModelSpace().getTransactionManager().commitTransaction();
        }
    }

    @Override
    public void undo() {
        this.newparent = (IEntity)this.Lookup((IModelElement)this.newparent, this.newparent_name);
        this.oldparent = (IEntity)this.Lookup((IModelElement)this.oldparent, this.oldparent_name);
        this.child = (IEntity)this.Lookup((IModelElement)this.child, this.child_name);
        this.newsource = this.Lookup(this.newsource, this.newsource_name);
        this.oldsource = this.Lookup(this.oldsource, this.oldsource_name);
        this.relation = (IRelation)this.Lookup((IModelElement)this.relation, this.relation_name);
        if (this.child != null && this.newparent != null && this.oldparent != null) {
            this.child.getModelSpace().getTransactionManager().undoTransaction(this.iTransactionID);
            this.child_name = this.child_oldname;
        } else if (this.relation != null && this.oldsource != null && this.newsource != null) {
            this.relation.getModelSpace().getTransactionManager().undoTransaction(this.iTransactionID);
            this.relation_name = this.relation_oldname;
        }
    }
}

