/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.treeeditor.providers;

import java.util.Collection;
import java.util.Set;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.viatra2.core.EMultiplicityKind;
import org.eclipse.viatra2.core.IEntity;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IRelation;
import org.eclipse.viatra2.tags.ITag;
import org.eclipse.viatra2.tags.TagKind;
import org.eclipse.viatra2.treeeditor.Plugin;
import org.eclipse.viatra2.treeeditor.ViatraTreeEditor;
import org.eclipse.viatra2.treeeditor.providers.ViatraContentProvider;

public class ViatraLabelProvider
extends LabelProvider
implements IColorProvider {
    private ViatraTreeEditor iVTE;
    private static Image eim = Plugin.getImageDescriptor("icons/entity_transparent.png").createImage();
    private static Image eim_warn = Plugin.getImageDescriptor("icons/entity_transparent_warning.png").createImage();
    private static Image eim_info = Plugin.getImageDescriptor("icons/entity_transparent_info.png").createImage();
    private static Image rim = Plugin.getImageDescriptor("icons/relation_transparent.png").createImage();
    private static Image rim_target = Plugin.getImageDescriptor("icons/relation_target_transparent.png").createImage();
    private static Image rim_warning = Plugin.getImageDescriptor("icons/relation_transparent_warning.png").createImage();
    private static Image rim_info = Plugin.getImageDescriptor("icons/relation_transparent_info.png").createImage();

    public ViatraLabelProvider(ViatraTreeEditor vte) {
        this.iVTE = vte;
    }

    public String getText(Object element) {
        if (element instanceof IModelElement || element instanceof ViatraContentProvider.TargetRelationDummy) {
            Object me = element instanceof ViatraContentProvider.TargetRelationDummy ? ((ViatraContentProvider.TargetRelationDummy)element).rel : (IModelElement)element;
            String formatString = "%n";
            if (element instanceof ViatraContentProvider.TargetRelationDummy) {
                formatString = this.iVTE.getFramework().getProperties().getRuntimeProperty("VIATRA2 Tree Editor", "Format string for Relation Targets");
            } else if (me instanceof IEntity) {
                formatString = this.iVTE.getFramework().getProperties().getRuntimeProperty("VIATRA2 Tree Editor", "Format string for Entities");
            } else if (me instanceof IRelation) {
                formatString = this.iVTE.getFramework().getProperties().getRuntimeProperty("VIATRA2 Tree Editor", "Format string for Relations");
            }
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < formatString.length()) {
                char c = formatString.charAt(i);
                if (c == '%' && i + 1 < formatString.length()) {
                    char c2 = formatString.charAt(++i);
                    int displayLimit = -1;
                    if (c2 == '[') {
                        ++i;
                        String sLimit = "";
                        while (i < formatString.length() && Character.isDigit(formatString.charAt(i))) {
                            sLimit = String.valueOf(sLimit) + formatString.charAt(i++);
                        }
                        if (sLimit.length() < 9) {
                            displayLimit = Integer.parseInt(sLimit);
                        }
                        if (i < formatString.length() && formatString.charAt(i) == ']') {
                            ++i;
                        }
                        if (i < formatString.length()) {
                            c2 = formatString.charAt(i);
                        }
                    }
                    String internalFormat = "";
                    int propPosition = -1;
                    if (c2 == '{') {
                        ++i;
                        while (i < formatString.length() && formatString.charAt(i) != '}') {
                            if (formatString.charAt(i) == '%') {
                                char c3;
                                char c4 = c3 = ++i < formatString.length() ? (char)formatString.charAt(i++) : (char)'.';
                                if (c3 == '%' || c3 == '$' || c3 == '}') {
                                    internalFormat = String.valueOf(internalFormat) + c3;
                                    continue;
                                }
                                internalFormat = String.valueOf(internalFormat) + '%';
                                --i;
                                continue;
                            }
                            if (formatString.charAt(i) == '$') {
                                ++i;
                                propPosition = internalFormat.length();
                                continue;
                            }
                            internalFormat = String.valueOf(internalFormat) + formatString.charAt(i++);
                        }
                        if (++i < formatString.length()) {
                            c2 = formatString.charAt(i);
                        }
                    }
                    if (c2 != '#') {
                        if (c2 == '%') {
                            sb.append('%');
                        } else {
                            EMultiplicityKind mult;
                            String prop = "";
                            while (i < formatString.length() && Character.isLetter(formatString.charAt(i))) {
                                prop = String.valueOf(prop) + formatString.charAt(i++);
                            }
                            --i;
                            boolean isFQN = prop.equals(prop.toUpperCase());
                            prop = prop.toLowerCase();
                            String propValue = "";
                            if ("name".equals(prop) || "n".equals(prop)) {
                                propValue = isFQN ? me.getFullyQualifiedName() : me.getName();
                            } else if ("value".equals(prop) || "v".equals(prop)) {
                                propValue = me instanceof IEntity ? ((IEntity)me).getValue() : "";
                            } else if ("source".equals(prop) || "src".equals(prop)) {
                                if (me instanceof IRelation) {
                                    propValue = isFQN ? ((IRelation)me).getFrom().getFullyQualifiedName() : ((IRelation)me).getFrom().getName();
                                }
                            } else if ("target".equals(prop) || "trg".equals(prop)) {
                                if (me instanceof IRelation) {
                                    propValue = isFQN ? ((IRelation)me).getTo().getFullyQualifiedName() : ((IRelation)me).getTo().getName();
                                }
                            } else if ("type".equals(prop) || "t".equals(prop)) {
                                propValue = this.elementCollectionToString(me.getTypes(), isFQN);
                            } else if ("instance".equals(prop) || "i".equals(prop)) {
                                propValue = this.elementCollectionToString(me.getInstances(), isFQN);
                            } else if ("supertype".equals(prop) || "s".equals(prop)) {
                                propValue = this.elementCollectionToString(me.getSupertypes(), isFQN);
                            } else if ("subtype".equals(prop) || "st".equals(prop)) {
                                propValue = this.elementCollectionToString(me.getSubtypes(), isFQN);
                            } else if ("alltype".equals(prop) || "at".equals(prop)) {
                                propValue = this.elementCollectionToString(me.getAllTypes(), isFQN);
                            } else if ("allinstance".equals(prop) || "ai".equals(prop)) {
                                propValue = this.elementCollectionToString(me.getAllInstances(), isFQN);
                            } else if ("allsupertype".equals(prop) || "as".equals(prop)) {
                                propValue = this.elementCollectionToString(me.getAllSupertypes(), isFQN);
                            } else if ("allsubtype".equals(prop) || "ast".equals(prop)) {
                                propValue = this.elementCollectionToString(me.getAllSubtypes(), isFQN);
                            } else if ("targetvalue".equals(prop) || "tv".equals(prop)) {
                                if (me instanceof IRelation && ((IRelation)me).getTo() instanceof IEntity) {
                                    propValue = ((IEntity)((IRelation)me).getTo()).getValue();
                                }
                            } else if ("targettype".equals(prop) || "tt".equals(prop)) {
                                if (me instanceof IRelation) {
                                    propValue = this.elementCollectionToString(((IRelation)me).getTo().getTypes(), isFQN);
                                }
                            } else if ("targetsupertype".equals(prop) || "ts".equals(prop)) {
                                if (me instanceof IRelation) {
                                    propValue = this.elementCollectionToString(((IRelation)me).getTo().getSupertypes(), isFQN);
                                }
                            } else if ("targetalltype".equals(prop) || "tat".equals(prop)) {
                                if (me instanceof IRelation) {
                                    propValue = this.elementCollectionToString(((IRelation)me).getTo().getAllTypes(), isFQN);
                                }
                            } else if ("targetallsupertype".equals(prop) || "tas".equals(prop)) {
                                if (me instanceof IRelation) {
                                    propValue = this.elementCollectionToString(((IRelation)me).getTo().getAllSupertypes(), isFQN);
                                }
                            } else if ("sourcemultiplicity".equals(prop) || "sm".equals(prop)) {
                                if (me instanceof IRelation) {
                                    mult = ((IRelation)me).getMultiplicity();
                                    propValue = mult == EMultiplicityKind.MANY_TO_MANY || mult == EMultiplicityKind.MANY_TO_ONE ? "*" : "1";
                                }
                            } else if ("targetmultiplicity".equals(prop) || "tm".equals(prop)) {
                                if (me instanceof IRelation) {
                                    mult = ((IRelation)me).getMultiplicity();
                                    propValue = mult == EMultiplicityKind.MANY_TO_MANY || mult == EMultiplicityKind.ONE_TO_MANY ? "*" : "1";
                                }
                            } else if (("isagregation".equals(prop) || "ag".equals(prop)) && me instanceof IRelation) {
                                String string = propValue = ((IRelation)me).getIsAggregation() ? "@" : "";
                            }
                            if (displayLimit > 0 && propValue.length() > displayLimit) {
                                propValue = String.valueOf(propValue.substring(0, displayLimit - 3)) + "...";
                            }
                            if (internalFormat.length() > 0 && propPosition >= 0 && propValue.length() > 0) {
                                propValue = String.valueOf(propPosition > 0 ? internalFormat.substring(0, propPosition) : "") + propValue + (propPosition < internalFormat.length() ? internalFormat.substring(propPosition) : "");
                            }
                            sb.append(propValue);
                        }
                    }
                } else {
                    sb.append(c);
                }
                ++i;
            }
            return sb.toString();
        }
        return "@@unknown element";
    }

    public Image getImage(Object element) {
        if (element instanceof IModelElement) {
            Set tags = this.iVTE.getFramework().getTagManager().getTagsForModelElement((IModelElement)element);
            boolean hasInfo = false;
            boolean hasWarning = false;
            if (tags != null) {
                for (ITag t : tags) {
                    if (t.getKind().equals((Object)TagKind.MODELING_INFO)) {
                        hasInfo = true;
                    }
                    if (!t.getKind().equals((Object)TagKind.MODELING_PROBLEM)) continue;
                    hasWarning = true;
                    break;
                }
            }
            if (element instanceof IEntity) {
                if (hasWarning) {
                    return eim_warn;
                }
                if (hasInfo) {
                    return eim_info;
                }
                return eim;
            }
            if (element instanceof IRelation) {
                if (hasWarning) {
                    return rim_warning;
                }
                if (hasInfo) {
                    return rim_info;
                }
                return rim;
            }
        } else if (element instanceof ViatraContentProvider.TargetRelationDummy) {
            return rim_target;
        }
        return null;
    }

    protected String elementCollectionToString(Collection<IModelElement> elements, boolean isFQN) {
        StringBuilder sb = new StringBuilder();
        boolean needComma = false;
        for (IModelElement elem : elements) {
            if (needComma) {
                sb.append(", ");
            } else {
                needComma = true;
            }
            if (isFQN) {
                sb.append(elem.getFullyQualifiedName());
                continue;
            }
            sb.append(elem.getName());
        }
        return sb.toString();
    }

    public Color getBackground(Object element) {
        Set tags;
        if (element instanceof IModelElement && (tags = this.iVTE.getFramework().getTagManager().getTagsForModelElement((IModelElement)element)) != null && tags.size() > 0) {
            return Display.getDefault().getSystemColor(((ITag)tags.iterator().next()).getBackgroundColor());
        }
        return null;
    }

    public Color getForeground(Object element) {
        Set tags;
        if (element instanceof IModelElement && (tags = this.iVTE.getFramework().getTagManager().getTagsForModelElement((IModelElement)element)) != null && tags.size() > 0) {
            return Display.getDefault().getSystemColor(((ITag)tags.iterator().next()).getForegroundColor());
        }
        return null;
    }
}

