/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.callgraph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.viatra2.core.IModelManager;
import org.eclipse.viatra2.gtasm.interpreter.exception.ViatraTransformationException;
import org.eclipse.viatra2.gtasm.interpreter.executionEnvironment.IExecutionEnvironment;
import org.eclipse.viatra2.gtasm.interpreter.impl.executionEnvironment.ExecutionEnvironment;
import org.eclipse.viatra2.gtasm.patternmatcher.exceptions.PatternMatcherCompileTimeException;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.core.PatternBuilder;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.EdgeType;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.PatternMatcher;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.VariableID;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.callgraph.EvenLevelNode;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.callgraph.FlattenedPattern;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.callgraph.IFlattenedPatternElement;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.callgraph.OddLevelNode;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.callgraph.PatternMatcherWrapper;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.callgraph.PatternNode;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.callgraph.PatternNodeIncremental;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.callgraph.PatternReferenceNode;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.callgraph.PatternVariantIterator;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.operation.CheckOperation;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.operation.NACCheckOperation;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.searchgraph.SearchGraphEdge;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.searchgraph.SearchGraphNode;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.searchgraph.traceability.EdgeTraceabilityElement;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.term.AbstractTermCheckOperation;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.term.ITermHandler;
import org.eclipse.viatra2.gtasm.patternmatcher.patterns.IPatternMatcher;
import org.eclipse.viatra2.gtasm.patternmatcher.patterns.PatternMatcherProvider;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.AnnotatedElement;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.RuntimeAnnotation;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Variable;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.GTPatternCall;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.Term;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.VariableReference;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.ContainmentConstraint;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTPattern;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTPatternBody;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.NonInjectivityConstraint;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.PatternVariable;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.PatternVariableAssignment;
import org.eclipse.viatra2.gtasmmodel.vpm.editmodel.ModelElement;
import org.eclipse.viatra2.logger.Logger;

public class BodyNode
extends EvenLevelNode
implements IFlattenedPatternElement {
    private GTPatternBody body;
    protected OddLevelNode[] children;

    BodyNode(PatternMatcher patternMatcher, PatternNode parent, GTPatternBody body) throws PatternMatcherCompileTimeException {
        super(parent);
        this.body = body;
        this.children = new OddLevelNode[body.getCalledPatterns().size()];
        EList patternCalls = body.getCalledPatterns();
        int i = 0;
        while (i < patternCalls.size()) {
            GTPatternCall patternCall = (GTPatternCall)patternCalls.get(i);
            PatternNode loopClosingNode = this.causesRecursion(patternCall.getCalledPattern());
            if (loopClosingNode == null) {
                if (this.isIncrementallyMatched(patternCall.getCalledPattern())) {
                    ExecutionEnvironment executionEnvironment = new ExecutionEnvironment(patternMatcher.getModelManager().getRoot().getModelSpace().getFramework());
                    try {
                        IPatternMatcher patternMatcherInc = null;
                        patternMatcherInc = PatternMatcherProvider.getInstance().getPatternMatcher((IExecutionEnvironment)executionEnvironment, patternCall.getCalledPattern());
                        PatternNodeIncremental child = new PatternNodeIncremental(new PatternMatcherWrapper(patternMatcherInc, patternMatcher.getLogger(), patternMatcher.getModelManager(), patternMatcher.getTermHandler()), this, patternCall);
                        this.children[i] = new PatternReferenceNode(this, patternCall, child);
                    }
                    catch (ViatraTransformationException e) {
                        String[] context = new String[]{patternCall.getCalledPattern().getName(), e.getMessage()};
                        throw new PatternMatcherCompileTimeException("[INTERNAL ERROR] The 1{} incrementally matched pattern does not have a valid pattern matcher: {2}", context, (AnnotatedElement)patternCall);
                    }
                } else {
                    PatternNode child = new PatternNode(patternMatcher, this, patternCall);
                    this.children[i] = child.isRoot() ? new PatternReferenceNode(this, patternCall, child) : child;
                }
            } else {
                this.children[i] = new PatternReferenceNode(this, patternCall, loopClosingNode);
            }
            ++i;
        }
    }

    private boolean isIncrementallyMatched(GTPattern calledPattern) throws PatternMatcherCompileTimeException {
        EList rtAnnotationsPattern;
        EList rtAnnotationsMachine = calledPattern.getNamespace().getRuntimeAnnotations();
        boolean isMachineIncremental = false;
        if (rtAnnotationsMachine != null && rtAnnotationsMachine.size() > 0) {
            for (RuntimeAnnotation an : rtAnnotationsMachine) {
                if ("@incremental".equals(an.getAnnotationName().toLowerCase())) {
                    isMachineIncremental = true;
                    continue;
                }
                if (!"@localsearch".equals(an.getAnnotationName().toLowerCase())) continue;
                isMachineIncremental = false;
            }
        }
        if ((rtAnnotationsPattern = calledPattern.getRuntimeAnnotations()) != null && rtAnnotationsPattern.size() > 0) {
            for (RuntimeAnnotation an : rtAnnotationsPattern) {
                if ("@incremental".equals(an.getAnnotationName().toLowerCase())) {
                    return true;
                }
                if (!"@localsearch".equals(an.getAnnotationName().toLowerCase())) continue;
                return false;
            }
        }
        return isMachineIncremental;
    }

    @Override
    protected PatternNode causesRecursion(GTPattern patternToTest) {
        return this.parent.causesRecursion(patternToTest);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected boolean traverse(PatternVariantIterator token) {
        size = this.children.length;
        if (BodyNode.$assertionsDisabled || this.index == 0 || this.index == size - 1) ** GOTO lbl9
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            if (this.children[this.index].traverse(token)) {
                ++this.index;
                continue;
            }
            this.children[this.index].index = 0;
            --this.index;
lbl9:
            // 3 sources

            ** while (this.index >= 0 && this.index < size)
        }
lbl10:
        // 1 sources

        result = this.index == size;
        --this.index;
        return result;
    }

    public GTPatternBody getBody() {
        return this.body;
    }

    public VariableID getVariableID(String name) {
        return new VariableID(this.parent.getPattern(), this.currentLocation, name);
    }

    public VariableID getVariableID(Variable variable) {
        return new VariableID(this.parent.getPattern(), this.currentLocation, variable.getName());
    }

    public VariableID getVariableID(ModelElement element) {
        return new VariableID(this.parent.getPattern(), this.currentLocation, element.getName());
    }

    private BodyNode getCallerBody() {
        return (BodyNode)this.parent.getParent();
    }

    @Override
    public void addLocalVariables(FlattenedPattern pattern) {
        for (PatternVariable variable : this.body.getLocalVariables()) {
            pattern.addVariable(this.getVariableID((Variable)variable));
        }
    }

    @Override
    public void addFormalParameters(FlattenedPattern pattern) throws PatternMatcherCompileTimeException {
        if (this.parent.isRoot()) {
            assert (this.body.getHeader() == this.parent.getPattern());
            GTPattern firstPattern = this.body.getHeader();
            EList formalParameters = firstPattern.getSymParameters();
            int numberOfFormalParameters = formalParameters.size();
            Integer i = 0;
            while (i < numberOfFormalParameters) {
                pattern.addVariable(this.getVariableID((Variable)formalParameters.get(i)));
                i = i + 1;
            }
            assert (firstPattern.getSymParameters().size() == pattern.getFrameSize());
        } else {
            Integer numberOfActualParameters = this.parent.getActualParameters().size();
            if (numberOfActualParameters.intValue() == this.parent.getPattern().getSymParameters().size()) {
                int j = 0;
                while (j < numberOfActualParameters) {
                    Term actualTerm = this.parent.getActualParameters().get(j);
                    PatternVariable formalParameter = (PatternVariable)this.parent.getPattern().getSymParameters().get(j);
                    if (!(actualTerm instanceof VariableReference)) {
                        String[] context = new String[]{"" + j, this.parent.getPattern().getName()};
                        throw new PatternMatcherCompileTimeException("The {1}. input parameter in the {2} pattern call is not a Variable.", context, (AnnotatedElement)actualTerm);
                    }
                    VariableReference varRef = (VariableReference)actualTerm;
                    PatternVariable actualParameter = (PatternVariable)varRef.getVariable();
                    Integer index = pattern.getIndex(this.getCallerBody().getVariableID((Variable)actualParameter));
                    pattern.setIndex(this.getVariableID((Variable)formalParameter), index);
                    ++j;
                }
            } else {
                String[] context = new String[]{this.parent.getPattern().getName()};
                throw new PatternMatcherCompileTimeException("[INTERNAL ERROR] The number of formal and actual parameters for the {1} pattern call do not match.", context, (AnnotatedElement)this.parent.getPattern());
            }
        }
    }

    @Override
    public Collection<FlattenedPattern.Pair> processVariableAssignments(FlattenedPattern pattern) throws PatternMatcherCompileTimeException {
        ArrayList<FlattenedPattern.Pair> pairs = null;
        EList assigments = this.body.getVariableAssignments();
        if (assigments != null) {
            pairs = new ArrayList<FlattenedPattern.Pair>();
            int i = 0;
            while (i < assigments.size()) {
                String[] context;
                VariableID leftID = this.getVariableID(((PatternVariableAssignment)assigments.get(i)).getLeftValue().getVariable());
                VariableID rightID = this.getVariableID(((PatternVariableAssignment)assigments.get(i)).getRightValue().getVariable());
                int left = pattern.getIndex(leftID);
                int right = pattern.getIndex(rightID);
                SearchGraphNode leftNode = pattern.getSearchGraph().getSearchNodes().get(left);
                SearchGraphNode rightNode = pattern.getSearchGraph().getSearchNodes().get(right);
                if (leftNode == null) {
                    context = new String[]{leftID.getFancyName()};
                    throw new PatternMatcherCompileTimeException("The {1} variable of the assigment cannot be locally resolved. The LS matcher does not support this", context, (AnnotatedElement)assigments.get(i));
                }
                if (rightNode == null) {
                    context = new String[]{rightID.getFancyName()};
                    throw new PatternMatcherCompileTimeException("The {1} variable of the assigment cannot be locally resolved. The LS matcher does not support this", context, (AnnotatedElement)assigments.get(i));
                }
                pairs.add(pattern.addInjectivityExclusionPair(left, right));
                SearchGraphEdge edge = new SearchGraphEdge();
                SearchGraphEdge invedge = new SearchGraphEdge();
                edge.setVPMEdgeType(EdgeType.VARIABLE_ASSIGNMENT);
                edge.setOldWeight(5);
                edge.setWeight(5);
                edge.setSourceNode(leftNode);
                edge.setTargetNode(rightNode);
                edge.setSource(true);
                edge.setName(String.valueOf(leftNode.getName()) + " variable assignment " + rightNode.getName());
                invedge.setVPMEdgeType(EdgeType.VARIABLE_ASSIGNMENT);
                invedge.setOldWeight(5);
                invedge.setWeight(5);
                invedge.setSourceNode(rightNode);
                invedge.setTargetNode(leftNode);
                invedge.setSource(false);
                invedge.setName(String.valueOf(rightNode.getName()) + " INVERSE variable assignment " + leftNode.getName());
                invedge.setInverseEdge(invedge);
                rightNode.addSource(edge);
                leftNode.addSource(invedge);
                EdgeTraceabilityElement edgeTraceability = new EdgeTraceabilityElement(edge, (AnnotatedElement)assigments.get(i));
                pattern.getSearchGraph().addTraceabilityElement(edge, edgeTraceability);
                EdgeTraceabilityElement inverseEdgeTraceability = new EdgeTraceabilityElement(invedge, (AnnotatedElement)assigments.get(i));
                pattern.getSearchGraph().addTraceabilityElement(invedge, inverseEdgeTraceability);
                ++i;
            }
        }
        return pairs;
    }

    @Override
    public Collection<FlattenedPattern.Pair> processInjectivityAssignments(FlattenedPattern pattern) throws PatternMatcherCompileTimeException {
        ArrayList<FlattenedPattern.Pair> pairs = null;
        EList constraints = this.body.getNonInjectivityConstraints();
        if (constraints != null) {
            pairs = new ArrayList<FlattenedPattern.Pair>();
            int i = 0;
            while (i < constraints.size()) {
                VariableID leftID = this.getVariableID(((NonInjectivityConstraint)constraints.get(i)).getLeftValue().getVariable());
                VariableID rightID = this.getVariableID(((NonInjectivityConstraint)constraints.get(i)).getRightValue().getVariable());
                int left = pattern.getIndex(leftID);
                int right = pattern.getIndex(rightID);
                pairs.add(pattern.addInjectivityInclusionPair(left, right));
                ++i;
            }
        }
        return pairs;
    }

    @Override
    public void generateElementInjectivityConstraints(FlattenedPattern flattenedPattern, Collection<FlattenedPattern.Pair> localAdditionalExclusionInjectivityPairs, Collection<FlattenedPattern.Pair> localAdditionalInclusionInjectivityPairs) throws PatternMatcherCompileTimeException {
        HashSet<Integer> bodyPatternIndexes = new HashSet<Integer>();
        boolean isDistinctMatching = this.parent.getPattern().isDistinctMatching();
        for (PatternVariable variable : this.body.getLocalVariables()) {
            Integer localVariableIndex = flattenedPattern.getIndex(this.getVariableID((Variable)variable));
            bodyPatternIndexes.add(localVariableIndex);
        }
        for (PatternVariable formalParemeter : this.parent.getPattern().getSymParameters()) {
            Integer formalParameterIndex = flattenedPattern.getIndex(this.getVariableID((Variable)formalParemeter));
            if (bodyPatternIndexes.add(formalParameterIndex)) continue;
            String[] context = new String[]{formalParameterIndex.toString(), this.parent.getPattern().getName()};
            throw new PatternMatcherCompileTimeException("[INTERNAL ERROR] The {1}. index is already added to the injectivity check set of the {2} pattern body ", context, (AnnotatedElement)this.body);
        }
        Collection<FlattenedPattern.Pair> localTransitivePairs = flattenedPattern.getTransitiveExclusionSet(localAdditionalExclusionInjectivityPairs, null, true);
        for (Integer i : bodyPatternIndexes) {
            for (Integer j : bodyPatternIndexes) {
                if (i >= j) continue;
                FlattenedPattern.Pair pair = new FlattenedPattern.Pair(i, j);
                if (isDistinctMatching) {
                    if (localAdditionalExclusionInjectivityPairs == null || localAdditionalExclusionInjectivityPairs.contains(pair) || localTransitivePairs.contains(pair)) continue;
                    flattenedPattern.addInjectivityInclusionPair(i, j);
                    continue;
                }
                if (localAdditionalInclusionInjectivityPairs == null || localAdditionalInclusionInjectivityPairs.contains(pair)) continue;
                flattenedPattern.addInjectivityExclusionPair(i, j);
            }
        }
    }

    @Override
    public void processCheckExpressions(FlattenedPattern pattern, Logger logger) {
        EList checkExpressions = this.body.getCheckExpressions();
        if (checkExpressions != null) {
            ITermHandler handler = pattern.getTermHandler();
            if (handler != null) {
                int i = 0;
                while (i < checkExpressions.size()) {
                    AbstractTermCheckOperation operation = handler.getTermCheckOperation(this.parent.getPattern(), this.currentLocation, (Term)checkExpressions.get(i));
                    pattern.addPostSearchPlanOperation(operation);
                    ++i;
                }
            } else {
                logger.warning("Term handler has not been specified. Term evaluation will not be executed");
            }
        }
    }

    @Override
    public void processNegativeApplicationConditions(FlattenedPattern pattern, Logger logger, IModelManager manager) throws PatternMatcherCompileTimeException {
        EList negativeCalls = this.body.getNegativePatterns();
        GTPattern header = this.body.getHeader();
        if (negativeCalls != null && negativeCalls.size() > 0) {
            int i = 0;
            while (i < negativeCalls.size()) {
                GTPatternCall call = (GTPatternCall)negativeCalls.get(i);
                PatternBuilder builder = new PatternBuilder(logger, manager, pattern.getTermHandler());
                IPatternMatcher matcher = builder.construct(call.getCalledPattern());
                EList actualTerms = call.getActualParameters();
                ArrayList<Variable> passingVariables = new ArrayList<Variable>();
                int[] actualParameterMapping = new int[actualTerms.size()];
                int j = 0;
                while (j < actualTerms.size()) {
                    Term term = (Term)actualTerms.get(j);
                    if (term instanceof VariableReference) {
                        VariableReference varRef = (VariableReference)term;
                        actualParameterMapping[j] = pattern.getIndex(this.getVariableID(varRef.getVariable()));
                        if (header.getSymParameters().contains((Object)varRef.getVariable())) {
                            passingVariables.add(varRef.getVariable());
                        }
                    } else {
                        String[] context = new String[]{"" + j, call.getCalledPattern().getName()};
                        throw new PatternMatcherCompileTimeException("The {1}. input parameter in the {2} NAC call is not a Variable.", context, (AnnotatedElement)call);
                    }
                    ++j;
                }
                NACCheckOperation operation = new NACCheckOperation(matcher, actualParameterMapping, call, passingVariables);
                pattern.addPostSearchPlanOperation(operation);
                ++i;
            }
        }
    }

    @Override
    public void buildSearchGraph(FlattenedPattern result) throws PatternMatcherCompileTimeException {
        try {
            result.getSearchGraph().add(this, result);
        }
        catch (PatternMatcherCompileTimeException e) {
            throw e.addNewStackElement((EObject)this.body);
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + this.parent.getPattern().getName() + "_" + this.currentLocation;
    }

    public CheckOperation getTermEvaluationOperation(ITermHandler handler, ContainmentConstraint conCons, int resultSlot) {
        return handler.getTermEvaluationOperation(this.parent.getPattern(), this.currentLocation, conCons, resultSlot);
    }
}

