/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.callgraph;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.viatra2.core.IModelManager;
import org.eclipse.viatra2.gtasm.patternmatcher.exceptions.PatternMatcherCompileTimeException;
import org.eclipse.viatra2.gtasm.patternmatcher.exceptions.PatternMatcherRuntimeException;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.MatchingFrame;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.PatternMatcher;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.callgraph.BodyNode;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.callgraph.EvenLevelNode;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.callgraph.FlattenedPattern;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.callgraph.IFlattenedPatternElement;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.callgraph.OddLevelNode;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.callgraph.PatternVariantIterator;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.operation.SearchPlanOperation;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.rgg.RemoteGoal;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.rgg.Rule;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.term.ITermHandler;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.AnnotatedElement;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.GTPatternCall;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTPattern;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTPatternBody;
import org.eclipse.viatra2.logger.Logger;

public class PatternNode
extends OddLevelNode
implements Iterable<List<IFlattenedPatternElement>> {
    private boolean isRoot;
    protected PatternMatcher patternMatcher;
    protected EvenLevelNode[] children;

    protected PatternNode(BodyNode parent, GTPatternCall call) {
        super((EvenLevelNode)parent, call);
        this.isRoot = false;
    }

    public PatternNode(PatternMatcher patternMatcher, BodyNode parent, GTPatternCall call) throws PatternMatcherCompileTimeException {
        super((EvenLevelNode)parent, call);
        this.isRoot = false;
        this.patternMatcher = patternMatcher;
        this.children = new BodyNode[this.getPattern().getPatternBodies().size()];
        this.buildCallGraph();
    }

    public PatternNode(PatternMatcher patternMatcher, GTPattern pattern) throws PatternMatcherCompileTimeException {
        super(null, pattern);
        this.isRoot = true;
        this.patternMatcher = patternMatcher;
        this.children = new BodyNode[pattern.getPatternBodies().size()];
        this.buildCallGraph();
    }

    private void buildCallGraph() throws PatternMatcherCompileTimeException {
        EList bodies = this.getPattern().getPatternBodies();
        int i = 0;
        while (i < bodies.size()) {
            this.children[i] = new BodyNode(this.patternMatcher, this, (GTPatternBody)bodies.get(i));
            ++i;
        }
        if (this.isRoot) {
            ArrayList<FlattenedPattern> flattenedPatterns = new ArrayList<FlattenedPattern>();
            for (List<IFlattenedPatternElement> patternVariant : this) {
                PatternNode.printPatternVariant(patternVariant, this.patternMatcher.getLogger());
                FlattenedPattern fp = new FlattenedPattern(this, patternVariant);
                flattenedPatterns.add(fp);
            }
            this.children = new FlattenedPattern[flattenedPatterns.size()];
            this.children = flattenedPatterns.toArray(this.children);
        }
    }

    @Override
    protected PatternNode causesRecursion(GTPattern patternToTest) {
        if (this.getPattern() == patternToTest) {
            this.isRoot = true;
            return this;
        }
        return this.getParent() == null ? null : this.getParent().causesRecursion(patternToTest);
    }

    @Override
    protected boolean traverse(PatternVariantIterator token) {
        int size = this.children.length;
        assert (this.index >= 0 && this.index <= size);
        if (this.index <= 0) {
            BodyNode body = (BodyNode)this.children[this.index];
            token.addLast(body);
            ++this.index;
            body.index = 0;
            return body.traverse(token);
        }
        BodyNode body = (BodyNode)this.children[this.index - 1];
        boolean successful = body.traverse(token);
        if (successful) {
            return true;
        }
        token.removeLast();
        if (this.index < size) {
            body = (BodyNode)this.children[this.index];
            ++this.index;
            token.addLast(body);
            body.index = 0;
            return body.traverse(token);
        }
        return false;
    }

    boolean isRoot() {
        return this.isRoot;
    }

    @Override
    public Iterator<List<IFlattenedPatternElement>> iterator() {
        return new PatternVariantIterator(this);
    }

    private static void printPatternVariant(List<IFlattenedPatternElement> patternVariant, Logger logger) {
        for (IFlattenedPatternElement element : patternVariant) {
            logger.debug(element.toString());
        }
    }

    public ITermHandler getTermHandler() {
        return this.patternMatcher.getTermHandler();
    }

    public Logger getLogger() {
        return this.patternMatcher.getLogger();
    }

    public IModelManager getModelManager() {
        return this.patternMatcher.getModelManager();
    }

    public FlattenedPattern getSingleFlattenedPattern() throws PatternMatcherCompileTimeException {
        if (this.children.length == 1 && this.children[0] instanceof FlattenedPattern) {
            return (FlattenedPattern)this.children[0];
        }
        String[] context = new String[]{};
        throw new PatternMatcherCompileTimeException("The pattern on the RHS of the gtRule cannot have alternative pattern bodies or be recursive.", context, (AnnotatedElement)this.getPattern());
    }

    public FlattenedPattern[] getFlattenedPatterns() throws PatternMatcherCompileTimeException {
        FlattenedPattern[] result = new FlattenedPattern[this.children.length];
        int i = 0;
        while (i < this.children.length) {
            if (this.children[i] instanceof FlattenedPattern) {
                result[i] = (FlattenedPattern)this.children[i];
            }
            ++i;
        }
        return result;
    }

    public String toString() {
        return this.getPattern().getName();
    }

    public RemoteGoal buildRuleGoalGraph(Boolean[] adornment, Map<String, RemoteGoal> rggRoots) throws PatternMatcherRuntimeException {
        RemoteGoal result = new RemoteGoal(this, adornment);
        rggRoots.put(RemoteGoal.generateID(this, adornment), result);
        int i = 0;
        while (i < this.children.length) {
            FlattenedPattern fp = (FlattenedPattern)this.children[i];
            List<SearchPlanOperation> finalSearchPlan = fp.generateSearchPlan(adornment, this.patternMatcher.getModelManager());
            TreeSet<Integer> preCallInterfaceVariables = new TreeSet<Integer>();
            int j = 0;
            while (j < adornment.length) {
                preCallInterfaceVariables.add(j);
                ++j;
            }
            Rule rule = (Rule)fp.buildSubtree(rggRoots, result.getMagicSet(), finalSearchPlan, finalSearchPlan.size() - 1, preCallInterfaceVariables);
            result.addChild(rule, new LinkedList<MatchingFrame>());
            ++i;
        }
        return result;
    }
}

