/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.rgg;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Vector;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.viatra2.gtasm.interpreter.exception.ViatraTransformationException;
import org.eclipse.viatra2.gtasm.patternmatcher.ExecutionMode;
import org.eclipse.viatra2.gtasm.patternmatcher.IMatching;
import org.eclipse.viatra2.gtasm.patternmatcher.ParameterMode;
import org.eclipse.viatra2.gtasm.patternmatcher.PatternCallSignature;
import org.eclipse.viatra2.gtasm.patternmatcher.Scope;
import org.eclipse.viatra2.gtasm.patternmatcher.exceptions.PatternMatcherRuntimeException;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.MatchingFrame;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.MatchingKey;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.callgraph.PatternNode;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.rgg.HistoryList;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.rgg.IndexedRule;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.rgg.RemoteGoal;
import org.eclipse.viatra2.gtasm.patternmatcher.patterns.IPatternMatcher;

public class RemoteGoalIncremental
extends RemoteGoal {
    private IPatternMatcher patternMatcher;
    private boolean isFirstTimeSync = true;
    private boolean isFirstTimeDelta = true;
    private Map<MatchingKey, List<IMatching>> mapWithAdornedIndex;
    private Map<MatchingKey, List<IMatching>> map;
    private Collection<IMatching> matchings;

    public RemoteGoalIncremental(PatternNode pattern, Boolean[] adornment, IPatternMatcher patternMatcher) {
        super(pattern, adornment);
        this.patternMatcher = patternMatcher;
        this.mapWithAdornedIndex = new HashMap<MatchingKey, List<IMatching>>();
        this.map = new HashMap<MatchingKey, List<IMatching>>();
    }

    @Override
    public void calculateAllDeltas(IndexedRule parent, Queue<MatchingFrame> output) throws PatternMatcherRuntimeException {
        HistoryList<MatchingKey, MatchingFrame> input = parent.getQueue();
        Iterator i = input.iterator();
        while (i.hasNext()) {
            MatchingFrame leftFrame = (MatchingFrame)i.next();
            MatchingKey keyForLeftFrame = parent.getBoundHeader(leftFrame);
            List<IMatching> list = this.mapWithAdornedIndex.get(keyForLeftFrame);
            if (list != null) {
                for (IMatching rightFrame : list) {
                    MatchingFrame newFrame = (MatchingFrame)leftFrame.clone();
                    parent.merge(newFrame, rightFrame);
                    output.offer(newFrame);
                }
            }
            this.ms.addArray(keyForLeftFrame);
            i.remove();
        }
        if (this.isFirstTimeDelta && this.matchings != null) {
            this.isFirstTimeDelta = false;
            for (List<IMatching> matchings : this.map.values()) {
                for (IMatching rightFrame : matchings) {
                    Vector<Object> v = new Vector<Object>();
                    int size = 0;
                    int i2 = 0;
                    while (i2 < this.adornment.length) {
                        if (this.adornment[i2].booleanValue()) {
                            v.add(rightFrame.lookup(i2));
                            ++size;
                        }
                        ++i2;
                    }
                    Object[] key = new Object[size];
                    v.toArray(key);
                    HistoryList<MatchingKey, MatchingFrame> queue = parent.getQueue();
                    List<MatchingFrame> list = queue.get(new MatchingKey(key));
                    if (list == null) continue;
                    for (MatchingFrame leftFrame : list) {
                        MatchingFrame newFrame = (MatchingFrame)leftFrame.clone();
                        parent.merge(newFrame, rightFrame);
                        output.offer(newFrame);
                    }
                }
            }
        }
    }

    @Override
    public boolean synchronize() throws ViatraTransformationException {
        this.debug();
        boolean result = false;
        if (this.isFirstTimeSync) {
            this.isFirstTimeSync = false;
            Object[] inputMapping = new Object[this.adornment.length];
            Integer[] quantificationOrder = new Integer[this.adornment.length];
            PatternCallSignature[] signature = new PatternCallSignature[this.adornment.length];
            int i = 0;
            while (i < signature.length) {
                PatternCallSignature _p = new PatternCallSignature();
                _p.setExecutionMode(ExecutionMode.MULTIPLE_RESULTS);
                _p.setParameterMode(ParameterMode.OUTPUT);
                _p.setParameterScope(new Scope());
                signature[i] = _p;
                ++i;
            }
            try {
                this.matchings = this.patternMatcher.matchAll(inputMapping, signature, quantificationOrder);
            }
            catch (ViatraTransformationException e) {
                throw e.addNewStackElement((EObject)this.pattern.getPattern());
            }
            for (IMatching matching : this.matchings) {
                MatchingKey keyForFrameAdorned = (MatchingKey)this.adornedKeyGenerator.calculateKey(matching);
                List<IMatching> currentList = this.mapWithAdornedIndex.get(keyForFrameAdorned);
                if (currentList == null) {
                    currentList = new LinkedList<IMatching>();
                }
                currentList.add(matching);
                this.mapWithAdornedIndex.put(keyForFrameAdorned, currentList);
                this.ms.addArray(keyForFrameAdorned);
                MatchingKey keyForFrame = (MatchingKey)this.keyGenerator.calculateKey(matching);
                currentList = this.map.get(keyForFrame);
                if (currentList == null) {
                    currentList = new LinkedList<IMatching>();
                    result = true;
                }
                currentList.add(matching);
                this.map.put(keyForFrame, currentList);
            }
        }
        return this.ms.synchronizeFromGoal() ? true : result;
    }

    @Override
    public void init() {
        this.ms.init();
        this.map.clear();
        this.matchings = null;
        this.mapWithAdornedIndex.clear();
        this.isFirstTimeSync = true;
        this.isFirstTimeDelta = true;
    }

    @Override
    public void matchAll() throws PatternMatcherRuntimeException {
    }

    @Override
    public void debug() {
    }
}

