/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.boundary;

import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.boundary.ReteBoundary;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.matcher.IPatternMatcherRuntimeContext;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.Direction;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.Network;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.Receiver;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.remote.Address;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.FlatTuple;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.Tuple;

public abstract class Feeder {
    protected Address<? extends Receiver> receiver;
    protected IPatternMatcherRuntimeContext<?> context;
    protected Network network;
    protected ReteBoundary<?> boundary;

    public Feeder(Address<? extends Receiver> receiver, IPatternMatcherRuntimeContext<?> context, Network network, ReteBoundary<?> boundary) {
        this.receiver = receiver;
        this.context = context;
        this.network = network;
        this.boundary = boundary;
    }

    public abstract void feed();

    protected void emit(Tuple tuple) {
        this.network.sendConstructionUpdate(this.receiver, Direction.INSERT, tuple);
    }

    protected IPatternMatcherRuntimeContext.ModelElementCrawler unaryCrawler() {
        return new IPatternMatcherRuntimeContext.ModelElementCrawler(){

            @Override
            public void crawl(Object element) {
                Feeder.this.emit(new FlatTuple(Feeder.this.boundary.wrapElement(element)));
            }
        };
    }

    protected IPatternMatcherRuntimeContext.ModelElementPairCrawler pairCrawler() {
        return new IPatternMatcherRuntimeContext.ModelElementPairCrawler(){

            @Override
            public void crawl(Object first, Object second) {
                Feeder.this.emit(new FlatTuple(Feeder.this.boundary.wrapElement(first), Feeder.this.boundary.wrapElement(second)));
            }
        };
    }

    protected IPatternMatcherRuntimeContext.ModelElementCrawler ternaryCrawler() {
        return new IPatternMatcherRuntimeContext.ModelElementCrawler(){

            @Override
            public void crawl(Object element) {
                Object relation = element;
                Object from = Feeder.this.context.ternaryEdgeSource(relation);
                Object to = Feeder.this.context.ternaryEdgeTarget(relation);
                Feeder.this.emit(new FlatTuple(Feeder.this.boundary.wrapElement(relation), Feeder.this.boundary.wrapElement(from), Feeder.this.boundary.wrapElement(to)));
            }
        };
    }
}

