/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.boundary;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.boundary.AbstractEvaluator;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.boundary.ReteBoundary;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.index.IdentityIndexer;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.index.NullIndexer;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.matcher.ReteEngine;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.Direction;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.Receiver;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.ReteContainer;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.remote.Address;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.single.SingleInputNode;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.Tuple;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.TupleMemory;

public class PredicateEvaluatorNode
extends SingleInputNode {
    protected ReteEngine<?> engine;
    protected ReteBoundary<?> boundary;
    protected Integer rhsIndex;
    protected int[] affectedIndices;
    protected Set<Tuple> outgoing;
    protected NullIndexer nullIndexer;
    protected IdentityIndexer identityIndexer;
    protected Map<Object, Collection<Tuple>> elementOccurences;
    protected Map<Tuple, Set<Tuple>> invoker2traces;
    protected Map<Tuple, Set<Tuple>> trace2invokers;
    protected Address<ASMFunctionTraceNotifierNode> asmFunctionTraceNotifier;
    protected Address<ElementChangeNotifierNode> elementChangeNotifier;
    protected AbstractEvaluator evaluator;

    public PredicateEvaluatorNode(ReteEngine<?> engine, ReteContainer container, Integer rhsIndex, int[] affectedIndices, int tupleWidth, AbstractEvaluator evaluator) {
        super(container);
        this.engine = engine;
        this.boundary = engine.getBoundary();
        this.rhsIndex = rhsIndex;
        this.affectedIndices = affectedIndices;
        this.evaluator = evaluator;
        this.elementOccurences = new HashMap<Object, Collection<Tuple>>();
        this.outgoing = new HashSet<Tuple>();
        this.invoker2traces = new HashMap<Tuple, Set<Tuple>>();
        this.trace2invokers = new HashMap<Tuple, Set<Tuple>>();
        this.asmFunctionTraceNotifier = Address.of(new ASMFunctionTraceNotifierNode(this.reteContainer));
        this.elementChangeNotifier = Address.of(new ElementChangeNotifierNode(this.reteContainer));
        this.nullIndexer = new NullIndexer(this.reteContainer, tupleWidth, this.outgoing, this);
        this.reteContainer.getLibrary().registerSpecializedProjectionIndexer(this, this.nullIndexer);
        this.identityIndexer = new IdentityIndexer(this.reteContainer, tupleWidth, this.outgoing, this);
        this.reteContainer.getLibrary().registerSpecializedProjectionIndexer(this, this.identityIndexer);
    }

    @Override
    public void pullInto(Collection<Tuple> collector) {
        for (Tuple ps : this.outgoing) {
            collector.add(this.boundary.wrapTuple(ps));
        }
    }

    @Override
    public void update(Direction direction, Tuple wrappers) {
        Tuple updateElement = this.boundary.unwrapTuple(wrappers);
        this.updateOccurences(direction, updateElement);
        if (direction == Direction.REVOKE) {
            if (this.outgoing.remove(updateElement)) {
                this.clearTraces(updateElement);
                this.propagateUpdate(Direction.REVOKE, wrappers);
            }
        } else {
            this.check(updateElement);
        }
    }

    protected void notifyASMFunctionValueChanged(Tuple trace) {
        Set<Tuple> invokers = this.trace2invokers.get(trace);
        if (invokers != null) {
            LinkedList<Tuple> copy = new LinkedList<Tuple>(invokers);
            for (Tuple ps : copy) {
                this.check(ps);
            }
        }
    }

    protected void notifyElementChange(Object element) {
        for (Tuple ps : this.elementOccurences.get(element)) {
            this.check(ps);
        }
    }

    protected void updateOccurences(Direction direction, Tuple ps) {
        int[] nArray = this.affectedIndices;
        int n = this.affectedIndices.length;
        int n2 = 0;
        while (n2 < n) {
            Integer i = nArray[n2];
            Object element = ps.get(i);
            this.updateElementOccurence(direction, ps, element);
            ++n2;
        }
    }

    protected void updateElementOccurence(Direction direction, Tuple ps, Object element) {
        if (direction == Direction.INSERT) {
            boolean change;
            TupleMemory occurences = this.elementOccurences.get(element);
            boolean bl = change = occurences == null;
            if (change) {
                occurences = new TupleMemory();
                this.elementOccurences.put(element, occurences);
                this.engine.getManipulationListener().registerSensitiveTerm(element, this);
            }
            occurences.add((Tuple)ps);
        } else {
            Collection<Tuple> occurences = this.elementOccurences.get(element);
            occurences.remove(ps);
            boolean change = occurences.isEmpty();
            if (change) {
                this.elementOccurences.remove(element);
                this.engine.getManipulationListener().unregisterSensitiveTerm(element, this);
            }
        }
    }

    protected void check(Tuple ps) {
        boolean result = this.evaluateExpression(ps);
        if (result) {
            if (this.outgoing.add(ps)) {
                this.propagateUpdate(Direction.INSERT, this.boundary.wrapTuple(ps));
            }
        } else if (this.outgoing.remove(ps)) {
            this.propagateUpdate(Direction.REVOKE, this.boundary.wrapTuple(ps));
        }
    }

    protected boolean evaluateExpression(Tuple ps) {
        Boolean rightHandSide;
        Object termResult = this.evaluateTerm(ps);
        Boolean bl = rightHandSide = this.rhsIndex == null ? Boolean.valueOf(true) : ps.get(this.rhsIndex);
        return termResult == null ? rightHandSide == null : termResult.equals(rightHandSide);
    }

    public Object evaluateTerm(Tuple ps) {
        this.clearTraces(ps);
        Object result = null;
        try {
            result = this.evaluator.evaluate(ps);
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.engine.getContext().logWarning("(Note: this is most likely a transient problem and can be usually ignored.) The incremental pattern matcher encountered an error during check() evaluation over variables " + this.prettyPrintTuple(ps) + " (Developer note: " + e.getClass().getSimpleName() + " in RETE term evaluator node). " + "Error message: " + e.getMessage(), e);
            this.engine.logEvaluatorException(e);
            result = Boolean.FALSE;
        }
        this.saveTraces(ps, this.evaluator.getTraces());
        return result;
    }

    protected String prettyPrintTuple(Tuple ps) {
        return ps.toString();
    }

    protected void clearTraces(Tuple invoker) {
        Set<Tuple> traces = this.invoker2traces.get(invoker);
        if (traces != null) {
            this.invoker2traces.remove(invoker);
            for (Tuple trace : traces) {
                Set<Tuple> invokers = this.trace2invokers.get(trace);
                invokers.remove(invoker);
                if (!invokers.isEmpty()) continue;
                this.trace2invokers.remove(trace);
                this.engine.geTraceListener().unregisterSensitiveTrace(trace, this);
            }
        }
    }

    protected void saveTraces(Tuple invoker, Set<Tuple> traces) {
        if (traces != null && !traces.isEmpty()) {
            this.invoker2traces.put(invoker, traces);
            for (Tuple trace : traces) {
                Set<Tuple> invokers = this.trace2invokers.get(trace);
                if (invokers == null) {
                    invokers = new HashSet<Tuple>();
                    this.trace2invokers.put(trace, invokers);
                    this.engine.geTraceListener().registerSensitiveTrace(trace, this);
                }
                invokers.add(invoker);
            }
        }
    }

    @Override
    protected void propagateUpdate(Direction direction, Tuple updateElement) {
        super.propagateUpdate(direction, updateElement);
        this.identityIndexer.propagate(direction, updateElement);
        boolean radical = direction == Direction.REVOKE && this.outgoing.isEmpty() || direction == Direction.INSERT && this.outgoing.size() == 1;
        this.nullIndexer.propagate(direction, updateElement, radical);
    }

    public Address<? extends Receiver> getAsmFunctionTraceNotifier() {
        return this.asmFunctionTraceNotifier;
    }

    public Address<? extends Receiver> getElementChangeNotifier() {
        return this.elementChangeNotifier;
    }

    public ReteEngine<?> getEngine() {
        return this.engine;
    }

    class ASMFunctionTraceNotifierNode
    extends SingleInputNode {
        public ASMFunctionTraceNotifierNode(ReteContainer reteContainer) {
            super(reteContainer);
        }

        @Override
        public void pullInto(Collection<Tuple> collector) {
        }

        @Override
        public void update(Direction direction, Tuple updateElement) {
            PredicateEvaluatorNode.this.notifyASMFunctionValueChanged(updateElement);
        }
    }

    class ElementChangeNotifierNode
    extends SingleInputNode {
        public ElementChangeNotifierNode(ReteContainer reteContainer) {
            super(reteContainer);
        }

        @Override
        public void pullInto(Collection<Tuple> collector) {
        }

        @Override
        public void update(Direction direction, Tuple updateElement) {
            PredicateEvaluatorNode.this.notifyElementChange(updateElement.get(0));
        }
    }
}

