/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.psystem;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.RetePatternBuildException;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.Stub;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.psystem.DeferredPConstraint;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.psystem.PSystem;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.psystem.PVariable;

public abstract class VariableDeferredPConstraint<PatternDescription, StubHandle>
extends DeferredPConstraint<PatternDescription, StubHandle> {
    public VariableDeferredPConstraint(PSystem<PatternDescription, StubHandle, ?> pSystem, Set<PVariable> affectedVariables) {
        super(pSystem, affectedVariables);
    }

    protected abstract Set<PVariable> getDeferringVariables();

    @Override
    public boolean isReadyAt(Stub<StubHandle> stub) {
        return stub.getVariablesIndex().keySet().containsAll(this.getDeferringVariables());
    }

    @Override
    public void raiseForeverDeferredError(Stub<StubHandle> stub) throws RetePatternBuildException {
        HashSet<PVariable> missing = new HashSet<PVariable>(this.getDeferringVariables());
        missing.removeAll(stub.getVariablesIndex().keySet());
        String[] args = new String[]{this.toString(), missing.toArray().toString()};
        String msg = "The checking of pattern constraint {1} requires the values of variables {2}, but it cannot be deferred further. HINT: the incremental matcher is not an equation solver, please make sure that all variable values are deducible.";
        throw new RetePatternBuildException(msg, args, null);
    }
}

