/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.index;

import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.index.StandardIndexer;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.Direction;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.ReteContainer;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.Supplier;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.MaskedTupleMemory;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.Tuple;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.TupleMask;

public abstract class MemoryIndexer
extends StandardIndexer {
    protected MaskedTupleMemory memory;

    public MemoryIndexer(ReteContainer reteContainer, TupleMask mask) {
        super(reteContainer, mask);
        this.memory = new MaskedTupleMemory(mask);
        reteContainer.registerClearable(this.memory);
    }

    public void update(Direction direction, Tuple updateElement) {
        Tuple signature = this.mask.transform(updateElement);
        boolean change = direction == Direction.INSERT ? this.memory.add(updateElement, signature) : this.memory.remove(updateElement, signature);
        this.update(direction, updateElement, signature, change);
    }

    protected abstract void update(Direction var1, Tuple var2, Tuple var3, boolean var4);

    public void appendParent(Supplier supplier) {
        if (this.parent != null) {
            throw new UnsupportedOperationException("Illegal RETE edge: " + this + " already has a parent (" + this.parent + ") and cannot connect to additional parent (" + supplier + "). ");
        }
        this.parent = supplier;
    }

    public void removeParent(Supplier supplier) {
        if (this.parent != supplier) {
            throw new IllegalArgumentException("Illegal RETE edge removal: the parent of " + this + " is not " + supplier);
        }
        this.parent = null;
    }
}

