/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.matcher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.boundary.ReteBoundary;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.index.Indexer;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.matcher.ReteEngine;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.Production;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.Receiver;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.remote.Address;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.single.TransformerNode;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.FlatTuple;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.Tuple;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.TupleMask;

public class RetePatternMatcher
extends TransformerNode {
    protected ReteEngine<?> engine;
    protected ReteBoundary<?> boundary;
    protected Production productionNode;
    protected HashMap<Object, Integer> posMapping;
    protected boolean connected = false;

    public RetePatternMatcher(ReteEngine<?> engine, Address<? extends Production> productionNode) {
        super(engine.getReteNet().getHeadContainer());
        this.engine = engine;
        this.boundary = engine.getBoundary();
        if (!engine.getReteNet().getHeadContainer().isLocal(productionNode)) {
            throw new IllegalArgumentException("@pre: Production must be local to the head container");
        }
        this.productionNode = engine.getReteNet().getHeadContainer().resolveLocal(productionNode);
        this.posMapping = this.productionNode.getPosMapping();
    }

    public Tuple matchOneRandomly(Object[] inputMapping) {
        ArrayList<Tuple> allMatches = this.matchAll(inputMapping, null);
        if (allMatches == null || allMatches.isEmpty()) {
            return null;
        }
        return allMatches.get((int)(Math.random() * (double)allMatches.size()));
    }

    public ArrayList<Tuple> matchAll(Object[] inputMapping, boolean[] fixed) {
        TupleMask mask = new TupleMask(fixed);
        Tuple inputSignature = mask.transform(new FlatTuple(inputMapping));
        AllMatchFetcher fetcher = new AllMatchFetcher(this.engine.accessProjection(this.productionNode, mask), this.boundary.wrapTuple(inputSignature));
        this.engine.reteNet.waitForReteTermination(fetcher);
        ArrayList<Tuple> unscopedMatches = fetcher.getMatches();
        if (unscopedMatches == null) {
            return new ArrayList<Tuple>();
        }
        return unscopedMatches;
    }

    public Tuple matchOne(Object[] inputMapping, boolean[] fixed) {
        TupleMask mask = new TupleMask(fixed);
        Tuple inputSignature = mask.transform(new FlatTuple(inputMapping));
        SingleMatchFetcher fetcher = new SingleMatchFetcher(this.engine.accessProjection(this.productionNode, mask), this.boundary.wrapTuple(inputSignature));
        this.engine.reteNet.waitForReteTermination(fetcher);
        return fetcher.getMatch();
    }

    public int count(Object[] inputMapping, boolean[] fixed) {
        TupleMask mask = new TupleMask(fixed);
        Tuple inputSignature = mask.transform(new FlatTuple(inputMapping));
        CountFetcher fetcher = new CountFetcher(this.engine.accessProjection(this.productionNode, mask), this.boundary.wrapTuple(inputSignature));
        this.engine.reteNet.waitForReteTermination(fetcher);
        return fetcher.getCount();
    }

    public synchronized void connect(Receiver receiver, boolean synchronize) {
        if (!this.connected) {
            this.reteContainer.connect(this.productionNode, this);
            this.connected = true;
        }
        if (synchronize) {
            this.reteContainer.connectAndSynchronize(this, receiver);
        } else {
            this.reteContainer.connect(this, receiver);
        }
    }

    public HashMap<Object, Integer> getPosMapping() {
        return this.posMapping;
    }

    @Override
    protected Tuple transform(Tuple input) {
        return this.boundary.unwrapTuple(input);
    }

    abstract class AbstractMatchFetcher
    implements Runnable {
        Indexer indexer;
        Tuple signature;

        public AbstractMatchFetcher(Indexer indexer, Tuple signature) {
            this.indexer = indexer;
            this.signature = signature;
        }

        @Override
        public void run() {
            this.fetch(this.indexer.get(this.signature));
        }

        protected abstract void fetch(Collection<Tuple> var1);
    }

    class AllMatchFetcher
    extends AbstractMatchFetcher {
        ArrayList<Tuple> matches;

        public AllMatchFetcher(Indexer indexer, Tuple signature) {
            super(indexer, signature);
            this.matches = null;
        }

        public ArrayList<Tuple> getMatches() {
            return this.matches;
        }

        @Override
        protected void fetch(Collection<Tuple> matches) {
            if (matches == null) {
                this.matches = null;
            } else {
                this.matches = new ArrayList(matches.size());
                int i = 0;
                for (Tuple t : matches) {
                    this.matches.add(i++, RetePatternMatcher.this.boundary.unwrapTuple(t));
                }
            }
        }
    }

    class CountFetcher
    extends AbstractMatchFetcher {
        int count;

        public CountFetcher(Indexer indexer, Tuple signature) {
            super(indexer, signature);
            this.count = 0;
        }

        public int getCount() {
            return this.count;
        }

        @Override
        protected void fetch(Collection<Tuple> matches) {
            this.count = matches == null ? 0 : matches.size();
        }
    }

    class SingleMatchFetcher
    extends AbstractMatchFetcher {
        Tuple match;

        public SingleMatchFetcher(Indexer indexer, Tuple signature) {
            super(indexer, signature);
            this.match = null;
        }

        public Tuple getMatch() {
            return this.match;
        }

        @Override
        protected void fetch(Collection<Tuple> matches) {
            if (matches != null && !matches.isEmpty()) {
                this.match = RetePatternMatcher.this.boundary.unwrapTuple(matches.iterator().next());
            }
        }
    }
}

