/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.incremental.adapters;

import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.framework.IMachineSetChangedListener;
import org.eclipse.viatra2.framework.properties.IViatraPropertyChangedListener;
import org.eclipse.viatra2.framework.properties.IViatraPropertyProvider;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.IncrementalPMPropertyProvider;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.adapters.ReteContainerGTASMBuildable;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.adapters.VPMGTASMContext;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.matcher.IPatternMatcherRuntimeContext;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.matcher.ReteEngine;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.Receiver;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.Supplier;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.remote.Address;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.simple.SimpleReteBuilder;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.RuntimeAnnotation;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.RuntimeAnnotationElement;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Machine;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTPattern;

public class MachineListener
implements IMachineSetChangedListener {
    WeakReference<IFramework> fw;
    ReteEngine<GTPattern> engine = null;
    Set<Machine> sensitiveMachines;
    int reteThreads;

    public MachineListener(IFramework framework) {
        this.fw = new WeakReference<IFramework>(framework);
        this.sensitiveMachines = new HashSet<Machine>();
        IViatraPropertyProvider provider = framework.getProperties().getProvider("Incremental Pattern Matcher");
        String threadStr = provider.getProperty("Number of parallel threads");
        this.setThreads(threadStr);
        provider.addListener(new IViatraPropertyChangedListener(){

            public void propertyChanged(String providerID, String propertyID, String oldVal, String newVal) {
                if (providerID.equals("Incremental Pattern Matcher") && propertyID.equals("Number of parallel threads")) {
                    MachineListener.this.setThreads(newVal);
                }
            }
        });
        framework.addMachineSetListener((IMachineSetChangedListener)this);
        for (Object machine : framework.getMachines()) {
            if (!(machine instanceof Machine)) continue;
            this.processMachine((Machine)machine);
        }
    }

    private void setThreads(String threadStr) {
        if (this.engine == null) {
            Integer threads = IncrementalPMPropertyProvider.interpretThreads(threadStr);
            this.reteThreads = threads == null ? 0 : threads;
        }
    }

    public void registerPattern(GTPattern gtPattern) {
        this.sensitiveMachines.add(gtPattern.getNamespace());
    }

    public void machineAdded(Object machine) {
        if (this.engine == null && machine instanceof Machine) {
            this.processMachine((Machine)machine);
        }
    }

    private void processMachine(Machine machine) {
        for (Object annot : machine.getRuntimeAnnotations()) {
            RuntimeAnnotation runtimeAnnotation = (RuntimeAnnotation)annot;
            if (!"@incremental".equals(runtimeAnnotation.getAnnotationName().toLowerCase())) continue;
            for (Object el : runtimeAnnotation.getElements()) {
                String value;
                Integer threads;
                RuntimeAnnotationElement runtimeAnnotationElement = (RuntimeAnnotationElement)el;
                String key = runtimeAnnotationElement.getKey().toLowerCase();
                if (!"parallel".equals(key) && !"threads".equals(key) || (threads = IncrementalPMPropertyProvider.interpretThreads(value = runtimeAnnotationElement.getValue())) == null) continue;
                ((IFramework)this.fw.get()).getProperties().setRuntimeProperty("Incremental Pattern Matcher", "Number of parallel threads", value);
            }
        }
    }

    public void machineRemoved(Object machine) {
        if (this.sensitiveMachines.contains(machine)) {
            this.sensitiveMachines.remove(machine);
            if (this.engine != null) {
                this.engine.reset();
            }
        }
    }

    private void initEngine() {
        IFramework framework = (IFramework)this.fw.get();
        VPMGTASMContext context = new VPMGTASMContext(framework);
        this.engine = new ReteEngine((IPatternMatcherRuntimeContext)context, this.reteThreads);
        ReteContainerGTASMBuildable buildable = new ReteContainerGTASMBuildable(this.engine, this.engine.getReteNet().getHeadContainer());
        this.engine.setBuilder(new SimpleReteBuilder<Address<? extends Supplier>, Address<? extends Receiver>>(buildable, context));
    }

    public ReteEngine<GTPattern> getEngine() {
        if (this.engine == null) {
            this.initEngine();
        }
        return this.engine;
    }

    public void kill() {
        if (this.engine != null) {
            this.engine.killEngine();
        }
        this.fw = null;
        this.sensitiveMachines = null;
    }
}

