/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.frameworkgui.actions;

import java.util.ArrayList;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.PlatformUI;
import org.eclipse.viatra2.frameworkgui.actions.AbstractFrameworkGUIAction;
import org.eclipse.viatra2.frameworkgui.views.FrameworkTreeView;
import org.eclipse.viatra2.loaders.LoaderFactory;

public class LoaderAction
extends AbstractFrameworkGUIAction {
    private String iLoaderID;

    public LoaderAction(FrameworkTreeView part, String loaderid) {
        this.setupInternals(part);
        this.iLoaderID = loaderid;
        this.setText("Load program model");
        this.setToolTipText("Load a program model into the registry");
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
    }

    public void run() {
        this.refreshSelection();
        FileDialog fop = new FileDialog(this.iFT.getSite().getShell(), 4096);
        fop.setText("Choose a program file to load");
        LoaderFactory lf = (LoaderFactory)this.iViatraFramework.getLoaders().get(this.iLoaderID);
        ArrayList<String> exts = new ArrayList<String>();
        String[] stringArray = lf.getFileExtensionList();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            exts.add("*." + ext);
            ++n2;
        }
        fop.setFilterExtensions(exts.toArray(new String[0]));
        fop.setFilterNames(exts.toArray(new String[0]));
        String fn = fop.open();
        if (fn != null) {
            try {
                Long c = System.currentTimeMillis();
                this.iViatraFramework.loadMachine(fn, this.iLoaderID);
                Long c2 = System.currentTimeMillis();
                this.iViatraFramework.getLogger().info("Machine load lasted for " + new Long(c2 - c).toString() + " ms");
            }
            catch (Exception exception) {
                this.iFT.showMessage("Error performing native import with " + this.iLoaderID);
            }
        }
    }
}

