/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.frameworkgui.content.nativefunctions;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource2;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.viatra2.natives.ASMNativeFunction;
import org.eclipse.viatra2.natives.NativeFunctionParameter;
import org.eclipse.viatra2.natives.VIATRANativeFunction;

public class NativeFunctionPropertySource
implements IPropertySource2 {
    ASMNativeFunction fNf;
    VIATRANativeFunction fNfA;

    public NativeFunctionPropertySource(ASMNativeFunction nf) {
        this.fNf = nf;
    }

    public boolean isPropertyResettable(Object id) {
        return false;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<PropertyDescriptor> ret = new ArrayList<PropertyDescriptor>();
        PropertyDescriptor pd = new PropertyDescriptor((Object)PROP_IDS.NAME, "Name");
        pd.setCategory("General");
        ret.add(pd);
        pd = new PropertyDescriptor((Object)PROP_IDS.ID, "ID");
        pd.setCategory("General");
        ret.add(pd);
        pd = new PropertyDescriptor((Object)PROP_IDS.DESC, "Description");
        pd.setCategory("General");
        ret.add(pd);
        Annotation[] annotationArray = this.fNf.getClass().getAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation a = annotationArray[n2];
            if (a.annotationType().equals(VIATRANativeFunction.class)) {
                this.fNfA = (VIATRANativeFunction)a;
                pd = new PropertyDescriptor((Object)PROP_IDS.REMARK, "Remark");
                pd.setCategory("General");
                ret.add(pd);
                pd = new PropertyDescriptor((Object)PROP_IDS.SIGNATURE, "Signature");
                pd.setCategory("General");
                ret.add(pd);
                NativeFunctionParameter[] nativeFunctionParameterArray = this.fNfA.params();
                int n3 = nativeFunctionParameterArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    NativeFunctionParameter p = nativeFunctionParameterArray[n4];
                    pd = new PropertyDescriptor((Object)(":" + p.name()), p.name());
                    pd.setCategory("Parameters");
                    ret.add(pd);
                    ++n4;
                }
            }
            ++n2;
        }
        return ret.toArray(new IPropertyDescriptor[0]);
    }

    public Object getPropertyValue(Object id) {
        if (id.equals((Object)PROP_IDS.ID)) {
            return this.fNf.getID();
        }
        if (id.equals((Object)PROP_IDS.NAME)) {
            return this.fNf.getName();
        }
        if (id.equals((Object)PROP_IDS.DESC)) {
            return this.fNf.getDescription();
        }
        if (id.equals((Object)PROP_IDS.REMARK)) {
            return this.fNfA != null ? this.fNfA.remark() : "";
        }
        if (id.equals((Object)PROP_IDS.SIGNATURE)) {
            return this.fNfA != null ? this.getFunctionSignature(this.fNfA) : "";
        }
        if (((String)id).startsWith(":")) {
            String pname = ((String)id).substring(1);
            NativeFunctionParameter[] nativeFunctionParameterArray = this.fNfA.params();
            int n = nativeFunctionParameterArray.length;
            int n2 = 0;
            while (n2 < n) {
                NativeFunctionParameter p = nativeFunctionParameterArray[n2];
                if (p.name().equals(pname)) {
                    return String.valueOf(p.description()) + " (variable argument number: " + p.isVarArg() + ")";
                }
                ++n2;
            }
        }
        return null;
    }

    protected String getParameterSignature(NativeFunctionParameter p) {
        String signature = "";
        NativeFunctionParameter.ParameterType[] parameterTypeArray = p.type();
        int n = parameterTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            NativeFunctionParameter.ParameterType t = parameterTypeArray[n2];
            signature = String.valueOf(signature) + "|" + t.name();
            if (p.isVarArg()) {
                signature = String.valueOf(signature) + "*";
            }
            ++n2;
        }
        signature = signature.substring(1);
        return signature;
    }

    protected String getFunctionSignature(VIATRANativeFunction f) {
        String s = String.valueOf(f.name()) + "( ";
        int i = 0;
        NativeFunctionParameter[] nativeFunctionParameterArray = f.params();
        int n = nativeFunctionParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            NativeFunctionParameter p = nativeFunctionParameterArray[n2];
            s = String.valueOf(s) + (i > 0 ? ", " + this.getParameterSignature(p) : this.getParameterSignature(p));
            ++i;
            s = String.valueOf(s) + " " + p.name();
            ++n2;
        }
        String ret = "";
        NativeFunctionParameter.ParameterType[] parameterTypeArray = f.returns();
        int n3 = parameterTypeArray.length;
        n = 0;
        while (n < n3) {
            NativeFunctionParameter.ParameterType t = parameterTypeArray[n];
            ret = String.valueOf(ret) + "|" + t.name();
            ++n;
        }
        return String.valueOf(s) + " ) : " + ret.substring(1);
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    static enum PROP_IDS {
        NAME,
        ID,
        DESC,
        ANNOTATIONS,
        REMARK,
        SIGNATURE;

    }
}

