/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.lpgparser.loader;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.framework.IFrameworkService;
import org.eclipse.viatra2.lpgparser.loader.VTCLParseController;

public class VTCLParserManager
implements IFrameworkService {
    private Map<String, VTCLParseController> parse_controllers = new HashMap<String, VTCLParseController>();
    private IFramework framework;

    public VTCLParseController createParseController(String vtclFileName) {
        VTCLParseController parseController = this.parse_controllers.get(vtclFileName);
        if (parseController == null) {
            parseController = new VTCLParseController();
            this.parse_controllers.put(vtclFileName, parseController);
            parseController.initialize(vtclFileName, this.framework);
        }
        return parseController;
    }

    public void deleteParseController(String vtclFileName) {
        VTCLParseController parseController = this.parse_controllers.get(vtclFileName);
        if (parseController != null) {
            this.parse_controllers.remove(vtclFileName);
        }
    }

    public VTCLParseController lookupParseController(String vtclFileName) {
        VTCLParseController parseController = this.parse_controllers.get(vtclFileName);
        if (parseController != null) {
            return parseController;
        }
        return null;
    }

    public VTCLParseController lookupAndCreateParseController(String vtclFileName) {
        VTCLParseController parseController = this.lookupParseController(vtclFileName);
        if (parseController != null) {
            parseController.initialize(vtclFileName, this.framework);
            return parseController;
        }
        return this.createParseController(vtclFileName);
    }

    public void init(IFramework fw) {
        this.framework = fw;
    }
}

