/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.visualisation.modelspace;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IRelation;
import org.eclipse.viatra2.visualisation.modelspace.datasource.filter.PreFilter;

public class ModelspaceTransactionChanges {
    private Set<IModelElement> newElements = new HashSet<IModelElement>();
    private Set<IModelElement> deletedElements = new HashSet<IModelElement>();

    public Collection<IModelElement> getNewElements() {
        return this.newElements;
    }

    public void addNewElement(IModelElement element) {
        this.newElements.add(element);
    }

    public void addNewElements(Collection<IModelElement> elements) {
        this.newElements.addAll(elements);
    }

    public Collection<IModelElement> getDeletedElements() {
        return this.deletedElements;
    }

    public void addRemovedElement(IModelElement element) {
        this.deletedElements.add(element);
        for (IRelation rel : element.getRelations()) {
            this.addRemovedElement((IModelElement)rel);
        }
    }

    public void addRemovedElements(Collection<IModelElement> elements) {
        this.deletedElements.addAll(elements);
    }

    public void handleLooseEdges(PreFilter filter) {
        HashSet<IModelElement> deletes = new HashSet<IModelElement>();
        this.newElements.removeAll(this.deletedElements);
        for (IModelElement element : this.deletedElements) {
            for (IRelation rel : element.getRelations()) {
                deletes.add((IModelElement)rel);
            }
        }
        this.addRemovedElements(deletes);
        HashSet<IModelElement> news = new HashSet<IModelElement>();
        for (IModelElement element : this.newElements) {
            if (!(element instanceof IRelation) || filter.isFiltered(element)) continue;
            IRelation rel = (IRelation)element;
            news.add(rel.getFrom());
            filter.includeElement(rel.getFrom());
            news.add(rel.getTo());
            filter.includeElement(rel.getTo());
        }
        this.addNewElements(news);
    }
}

