/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.visualisation.patterns;

import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.viatra2.visualisation.ViatraGraphViewer;
import org.eclipse.viatra2.visualisation.patterns.PatternGraphDescriptor;
import org.eclipse.viatra2.visualisation.patterns.viewmodel.ViewPattern;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphContainer;
import org.eclipse.zest.core.widgets.GraphItem;
import org.eclipse.zest.core.widgets.GraphNode;
import org.eclipse.zest.layouts.LayoutAlgorithm;

public class PatternGraphViewer
extends ViatraGraphViewer {
    LayoutAlgorithm compoundLayout;

    public void setCompoundLayout(LayoutAlgorithm compoundLayout) {
        this.compoundLayout = compoundLayout;
    }

    public PatternGraphViewer(Composite composite, int style) {
        super(composite, style);
        final Graph g = this.getGraphControl();
        final PatternGraphViewer gv = this;
        g.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                IFigure o = g.getFigureAt(e.x, e.y);
                if (o != null) {
                    for (Object selected : ((StructuredSelection)gv.getSelection()).toList()) {
                        GraphItem foundItem = gv.findGraphItem(selected);
                        if (!(foundItem instanceof GraphNode) || !((GraphNode)foundItem).getNodeFigure().equals(o)) continue;
                        PatternGraphViewer.this.nodeDoubleClicked(selected);
                    }
                }
            }
        });
    }

    private void nodeDoubleClicked(Object o) {
        if (o instanceof ViewPattern) {
            ((PatternGraphDescriptor)this.descriptor).pushItem(((ViewPattern)o).getPattern());
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.compoundLayout == null) {
            return;
        }
        for (Object _node : this.getGraphControl().getNodes()) {
            GraphNode node = (GraphNode)_node;
            if (!(node instanceof GraphContainer)) continue;
            GraphContainer graphContainer = (GraphContainer)node;
            graphContainer.setSize(-1.0, -1.0);
            graphContainer.setLayoutAlgorithm(this.compoundLayout, true);
        }
    }
}

