/**
 * Copyright (c) 2004-2015, Istvan David, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * Istvan David - initial API and implementation
 */
package org.eclipse.viatra.cep.core.api.engine;

import org.eclipse.emf.common.util.EList;
import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.emf.EMFScope;
import org.eclipse.viatra.cep.core.engine.runtime.ResettableEventTokenMatch;
import org.eclipse.viatra.cep.core.engine.runtime.ResettableEventTokenMatcher;
import org.eclipse.viatra.cep.core.metamodels.automaton.Automaton;
import org.eclipse.viatra.cep.core.metamodels.automaton.EventToken;
import org.eclipse.viatra.cep.core.metamodels.automaton.InternalModel;
import org.eclipse.viatra.emf.runtime.modelmanipulation.IModelManipulations;
import org.eclipse.viatra.emf.runtime.modelmanipulation.SimpleModelManipulations;
import org.eclipse.viatra.emf.runtime.rules.batch.BatchTransformationRule;
import org.eclipse.viatra.emf.runtime.rules.batch.BatchTransformationRuleFactory;
import org.eclipse.viatra.emf.runtime.rules.batch.BatchTransformationStatements;
import org.eclipse.viatra.emf.runtime.transformation.batch.BatchTransformation;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function0;

@SuppressWarnings("all")
public class ResetTransformations {
  @Extension
  private BatchTransformationRuleFactory ruleFactory = new BatchTransformationRuleFactory();
  
  @Extension
  private BatchTransformation transformation;
  
  @Extension
  private BatchTransformationStatements statements;
  
  @Extension
  private IModelManipulations manipulation;
  
  public ResetTransformations(final InternalModel internalModel) {
    try {
      EMFScope _eMFScope = new EMFScope(internalModel);
      BatchTransformation _forScope = BatchTransformation.forScope(_eMFScope);
      this.transformation = _forScope;
      BatchTransformationStatements _batchTransformationStatements = new BatchTransformationStatements(this.transformation);
      this.statements = _batchTransformationStatements;
      IncQueryEngine _iqEngine = this.transformation.getIqEngine();
      SimpleModelManipulations _simpleModelManipulations = new SimpleModelManipulations(_iqEngine);
      this.manipulation = _simpleModelManipulations;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public boolean resetAll() {
    return this.statements.<ResettableEventTokenMatch>fireWhilePossible(this.deleteTokensDuringReset);
  }
  
  private final BatchTransformationRule<ResettableEventTokenMatch, ResettableEventTokenMatcher> deleteTokensDuringReset = new Function0<BatchTransformationRule<ResettableEventTokenMatch, ResettableEventTokenMatcher>>() {
    public BatchTransformationRule<ResettableEventTokenMatch, ResettableEventTokenMatcher> apply() {
      try {
        IQuerySpecification<ResettableEventTokenMatcher> _querySpecification = ResettableEventTokenMatcher.querySpecification();
        final IMatchProcessor<ResettableEventTokenMatch> _function = new IMatchProcessor<ResettableEventTokenMatch>() {
          @Override
          public void process(final ResettableEventTokenMatch it) {
            Automaton _automaton = it.getAutomaton();
            EList<EventToken> _eventTokens = _automaton.getEventTokens();
            EventToken _eventToken = it.getEventToken();
            _eventTokens.remove(_eventToken);
          }
        };
        BatchTransformationRule<ResettableEventTokenMatch, ResettableEventTokenMatcher> _createRule = ResetTransformations.this.ruleFactory.<ResettableEventTokenMatch, ResettableEventTokenMatcher>createRule(_querySpecification, _function);
        return _createRule;
      } catch (Throwable _e) {
        throw Exceptions.sneakyThrow(_e);
      }
    }
  }.apply();
}
