package org.eclipse.viatra.cep.core.engine.compiler;

import java.util.Arrays;
import java.util.List;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.impl.BasePatternMatch;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.viatra.cep.core.engine.compiler.util.AtomicEventPatternQuerySpecification;
import org.eclipse.viatra.cep.core.metamodels.events.AtomicEventPattern;

/**
 * Pattern-specific match representation of the org.eclipse.viatra.cep.core.engine.compiler.atomicEventPattern pattern,
 * to be used in conjunction with {@link AtomicEventPatternMatcher}.
 * 
 * <p>Class fields correspond to parameters of the pattern. Fields with value null are considered unassigned.
 * Each instance is a (possibly partial) substitution of pattern parameters,
 * usable to represent a match of the pattern in the result of a query,
 * or to specify the bound (fixed) input parameters when issuing a query.
 * 
 * @see AtomicEventPatternMatcher
 * @see AtomicEventPatternProcessor
 * 
 */
@SuppressWarnings("all")
public abstract class AtomicEventPatternMatch extends BasePatternMatch {
  private AtomicEventPattern fEventPattern;
  
  private static List<String> parameterNames = makeImmutableList("eventPattern");
  
  private AtomicEventPatternMatch(final AtomicEventPattern pEventPattern) {
    this.fEventPattern = pEventPattern;
  }
  
  @Override
  public Object get(final String parameterName) {
    if ("eventPattern".equals(parameterName)) return this.fEventPattern;
    return null;
  }
  
  public AtomicEventPattern getEventPattern() {
    return this.fEventPattern;
  }
  
  @Override
  public boolean set(final String parameterName, final Object newValue) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    if ("eventPattern".equals(parameterName) ) {
    	this.fEventPattern = (org.eclipse.viatra.cep.core.metamodels.events.AtomicEventPattern) newValue;
    	return true;
    }
    return false;
  }
  
  public void setEventPattern(final AtomicEventPattern pEventPattern) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fEventPattern = pEventPattern;
  }
  
  @Override
  public String patternName() {
    return "org.eclipse.viatra.cep.core.engine.compiler.atomicEventPattern";
  }
  
  @Override
  public List<String> parameterNames() {
    return AtomicEventPatternMatch.parameterNames;
  }
  
  @Override
  public Object[] toArray() {
    return new Object[]{fEventPattern};
  }
  
  @Override
  public AtomicEventPatternMatch toImmutable() {
    return isMutable() ? newMatch(fEventPattern) : this;
  }
  
  @Override
  public String prettyPrint() {
    StringBuilder result = new StringBuilder();
    result.append("\"eventPattern\"=" + prettyPrintValue(fEventPattern)
    );
    return result.toString();
  }
  
  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((fEventPattern == null) ? 0 : fEventPattern.hashCode());
    return result;
  }
  
  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
    	return true;
    if (!(obj instanceof AtomicEventPatternMatch)) { // this should be infrequent
    	if (obj == null) {
    		return false;
    	}
    	if (!(obj instanceof IPatternMatch)) {
    		return false;
    	}
    	IPatternMatch otherSig  = (IPatternMatch) obj;
    	if (!specification().equals(otherSig.specification()))
    		return false;
    	return Arrays.deepEquals(toArray(), otherSig.toArray());
    }
    AtomicEventPatternMatch other = (AtomicEventPatternMatch) obj;
    if (fEventPattern == null) {if (other.fEventPattern != null) return false;}
    else if (!fEventPattern.equals(other.fEventPattern)) return false;
    return true;
  }
  
  @Override
  public AtomicEventPatternQuerySpecification specification() {
    try {
    	return AtomicEventPatternQuerySpecification.instance();
    } catch (IncQueryException ex) {
     	// This cannot happen, as the match object can only be instantiated if the query specification exists
     	throw new IllegalStateException (ex);
    }
  }
  
  /**
   * Returns an empty, mutable match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @return the empty match.
   * 
   */
  public static AtomicEventPatternMatch newEmptyMatch() {
    return new Mutable(null);
  }
  
  /**
   * Returns a mutable (partial) match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @param pEventPattern the fixed value of pattern parameter eventPattern, or null if not bound.
   * @return the new, mutable (partial) match object.
   * 
   */
  public static AtomicEventPatternMatch newMutableMatch(final AtomicEventPattern pEventPattern) {
    return new Mutable(pEventPattern);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pEventPattern the fixed value of pattern parameter eventPattern, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public static AtomicEventPatternMatch newMatch(final AtomicEventPattern pEventPattern) {
    return new Immutable(pEventPattern);
  }
  
  private static final class Mutable extends AtomicEventPatternMatch {
    Mutable(final AtomicEventPattern pEventPattern) {
      super(pEventPattern);
    }
    
    @Override
    public boolean isMutable() {
      return true;
    }
  }
  
  private static final class Immutable extends AtomicEventPatternMatch {
    Immutable(final AtomicEventPattern pEventPattern) {
      super(pEventPattern);
    }
    
    @Override
    public boolean isMutable() {
      return false;
    }
  }
}
