package org.eclipse.viatra.cep.core.engine.compiler;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseMatcher;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.incquery.runtime.util.IncQueryLoggingUtil;
import org.eclipse.viatra.cep.core.engine.compiler.ComplexNotTransitionMatch;
import org.eclipse.viatra.cep.core.engine.compiler.util.ComplexNotTransitionQuerySpecification;
import org.eclipse.viatra.cep.core.metamodels.automaton.Automaton;
import org.eclipse.viatra.cep.core.metamodels.automaton.TypedTransition;
import org.eclipse.viatra.cep.core.metamodels.events.ComplexEventPattern;

/**
 * Generated pattern matcher API of the org.eclipse.viatra.cep.core.engine.compiler.complexNotTransition pattern,
 * providing pattern-specific query methods.
 * 
 * <p>Use the pattern matcher on a given model via {@link #on(IncQueryEngine)},
 * e.g. in conjunction with {@link IncQueryEngine#on(Notifier)}.
 * 
 * <p>Matches of the pattern will be represented as {@link ComplexNotTransitionMatch}.
 * 
 * <p>Original source:
 * <code><pre>
 * pattern
 * complexNotTransition(automaton : Automaton, transition : TypedTransition, eventPattern : ComplexEventPattern) {
 * 	find complexTransition(automaton, transition, eventPattern, _);
 * 	find negativeTransition(transition);
 * }
 * </pre></code>
 * 
 * @see ComplexNotTransitionMatch
 * @see ComplexNotTransitionProcessor
 * @see ComplexNotTransitionQuerySpecification
 * 
 */
@SuppressWarnings("all")
public class ComplexNotTransitionMatcher extends BaseMatcher<ComplexNotTransitionMatch> {
  /**
   * Initializes the pattern matcher within an existing EMF-IncQuery engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing EMF-IncQuery engine in which this matcher will be created.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * 
   */
  public static ComplexNotTransitionMatcher on(final IncQueryEngine engine) throws IncQueryException {
    // check if matcher already exists
    ComplexNotTransitionMatcher matcher = engine.getExistingMatcher(querySpecification());
    if (matcher == null) {
    	matcher = new ComplexNotTransitionMatcher(engine);
    	// do not have to "put" it into engine.matchers, reportMatcherInitialized() will take care of it
    }
    return matcher;
  }
  
  private final static int POSITION_AUTOMATON = 0;
  
  private final static int POSITION_TRANSITION = 1;
  
  private final static int POSITION_EVENTPATTERN = 2;
  
  private final static Logger LOGGER = IncQueryLoggingUtil.getLogger(ComplexNotTransitionMatcher.class);
  
  /**
   * Initializes the pattern matcher over a given EMF model root (recommended: Resource or ResourceSet).
   * If a pattern matcher is already constructed with the same root, only a light-weight reference is returned.
   * The scope of pattern matching will be the given EMF model root and below (see FAQ for more precise definition).
   * The match set will be incrementally refreshed upon updates from this scope.
   * <p>The matcher will be created within the managed {@link IncQueryEngine} belonging to the EMF model root, so
   * multiple matchers will reuse the same engine and benefit from increased performance and reduced memory footprint.
   * @param emfRoot the root of the EMF containment hierarchy where the pattern matcher will operate. Recommended: Resource or ResourceSet.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * @deprecated use {@link #on(IncQueryEngine)} instead, e.g. in conjunction with {@link IncQueryEngine#on(Notifier)}
   * 
   */
  @Deprecated
  public ComplexNotTransitionMatcher(final Notifier emfRoot) throws IncQueryException {
    this(IncQueryEngine.on(emfRoot));
  }
  
  /**
   * Initializes the pattern matcher within an existing EMF-IncQuery engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing EMF-IncQuery engine in which this matcher will be created.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * @deprecated use {@link #on(IncQueryEngine)} instead
   * 
   */
  @Deprecated
  public ComplexNotTransitionMatcher(final IncQueryEngine engine) throws IncQueryException {
    super(engine, querySpecification());
  }
  
  /**
   * Returns the set of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @param pTransition the fixed value of pattern parameter transition, or null if not bound.
   * @param pEventPattern the fixed value of pattern parameter eventPattern, or null if not bound.
   * @return matches represented as a ComplexNotTransitionMatch object.
   * 
   */
  public Collection<ComplexNotTransitionMatch> getAllMatches(final Automaton pAutomaton, final TypedTransition pTransition, final ComplexEventPattern pEventPattern) {
    return rawGetAllMatches(new Object[]{pAutomaton, pTransition, pEventPattern});
  }
  
  /**
   * Returns an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @param pTransition the fixed value of pattern parameter transition, or null if not bound.
   * @param pEventPattern the fixed value of pattern parameter eventPattern, or null if not bound.
   * @return a match represented as a ComplexNotTransitionMatch object, or null if no match is found.
   * 
   */
  public ComplexNotTransitionMatch getOneArbitraryMatch(final Automaton pAutomaton, final TypedTransition pTransition, final ComplexEventPattern pEventPattern) {
    return rawGetOneArbitraryMatch(new Object[]{pAutomaton, pTransition, pEventPattern});
  }
  
  /**
   * Indicates whether the given combination of specified pattern parameters constitute a valid pattern match,
   * under any possible substitution of the unspecified parameters (if any).
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @param pTransition the fixed value of pattern parameter transition, or null if not bound.
   * @param pEventPattern the fixed value of pattern parameter eventPattern, or null if not bound.
   * @return true if the input is a valid (partial) match of the pattern.
   * 
   */
  public boolean hasMatch(final Automaton pAutomaton, final TypedTransition pTransition, final ComplexEventPattern pEventPattern) {
    return rawHasMatch(new Object[]{pAutomaton, pTransition, pEventPattern});
  }
  
  /**
   * Returns the number of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @param pTransition the fixed value of pattern parameter transition, or null if not bound.
   * @param pEventPattern the fixed value of pattern parameter eventPattern, or null if not bound.
   * @return the number of pattern matches found.
   * 
   */
  public int countMatches(final Automaton pAutomaton, final TypedTransition pTransition, final ComplexEventPattern pEventPattern) {
    return rawCountMatches(new Object[]{pAutomaton, pTransition, pEventPattern});
  }
  
  /**
   * Executes the given processor on each match of the pattern that conforms to the given fixed values of some parameters.
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @param pTransition the fixed value of pattern parameter transition, or null if not bound.
   * @param pEventPattern the fixed value of pattern parameter eventPattern, or null if not bound.
   * @param processor the action that will process each pattern match.
   * 
   */
  public void forEachMatch(final Automaton pAutomaton, final TypedTransition pTransition, final ComplexEventPattern pEventPattern, final IMatchProcessor<? super ComplexNotTransitionMatch> processor) {
    rawForEachMatch(new Object[]{pAutomaton, pTransition, pEventPattern}, processor);
  }
  
  /**
   * Executes the given processor on an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @param pTransition the fixed value of pattern parameter transition, or null if not bound.
   * @param pEventPattern the fixed value of pattern parameter eventPattern, or null if not bound.
   * @param processor the action that will process the selected match.
   * @return true if the pattern has at least one match with the given parameter values, false if the processor was not invoked
   * 
   */
  public boolean forOneArbitraryMatch(final Automaton pAutomaton, final TypedTransition pTransition, final ComplexEventPattern pEventPattern, final IMatchProcessor<? super ComplexNotTransitionMatch> processor) {
    return rawForOneArbitraryMatch(new Object[]{pAutomaton, pTransition, pEventPattern}, processor);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @param pTransition the fixed value of pattern parameter transition, or null if not bound.
   * @param pEventPattern the fixed value of pattern parameter eventPattern, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public ComplexNotTransitionMatch newMatch(final Automaton pAutomaton, final TypedTransition pTransition, final ComplexEventPattern pEventPattern) {
    return ComplexNotTransitionMatch.newMatch(pAutomaton, pTransition, pEventPattern);
  }
  
  /**
   * Retrieve the set of values that occur in matches for automaton.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<Automaton> rawAccumulateAllValuesOfautomaton(final Object[] parameters) {
    Set<Automaton> results = new HashSet<Automaton>();
    rawAccumulateAllValues(POSITION_AUTOMATON, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for automaton.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Automaton> getAllValuesOfautomaton() {
    return rawAccumulateAllValuesOfautomaton(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for automaton.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Automaton> getAllValuesOfautomaton(final ComplexNotTransitionMatch partialMatch) {
    return rawAccumulateAllValuesOfautomaton(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for automaton.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Automaton> getAllValuesOfautomaton(final TypedTransition pTransition, final ComplexEventPattern pEventPattern) {
    return rawAccumulateAllValuesOfautomaton(new Object[]{
    null, 
    pTransition, 
    pEventPattern
    });
  }
  
  /**
   * Retrieve the set of values that occur in matches for transition.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<TypedTransition> rawAccumulateAllValuesOftransition(final Object[] parameters) {
    Set<TypedTransition> results = new HashSet<TypedTransition>();
    rawAccumulateAllValues(POSITION_TRANSITION, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for transition.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<TypedTransition> getAllValuesOftransition() {
    return rawAccumulateAllValuesOftransition(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for transition.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<TypedTransition> getAllValuesOftransition(final ComplexNotTransitionMatch partialMatch) {
    return rawAccumulateAllValuesOftransition(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for transition.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<TypedTransition> getAllValuesOftransition(final Automaton pAutomaton, final ComplexEventPattern pEventPattern) {
    return rawAccumulateAllValuesOftransition(new Object[]{
    pAutomaton, 
    null, 
    pEventPattern
    });
  }
  
  /**
   * Retrieve the set of values that occur in matches for eventPattern.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<ComplexEventPattern> rawAccumulateAllValuesOfeventPattern(final Object[] parameters) {
    Set<ComplexEventPattern> results = new HashSet<ComplexEventPattern>();
    rawAccumulateAllValues(POSITION_EVENTPATTERN, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for eventPattern.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<ComplexEventPattern> getAllValuesOfeventPattern() {
    return rawAccumulateAllValuesOfeventPattern(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for eventPattern.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<ComplexEventPattern> getAllValuesOfeventPattern(final ComplexNotTransitionMatch partialMatch) {
    return rawAccumulateAllValuesOfeventPattern(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for eventPattern.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<ComplexEventPattern> getAllValuesOfeventPattern(final Automaton pAutomaton, final TypedTransition pTransition) {
    return rawAccumulateAllValuesOfeventPattern(new Object[]{
    pAutomaton, 
    pTransition, 
    null
    });
  }
  
  @Override
  protected ComplexNotTransitionMatch tupleToMatch(final Tuple t) {
    try {
    	return ComplexNotTransitionMatch.newMatch((org.eclipse.viatra.cep.core.metamodels.automaton.Automaton) t.get(POSITION_AUTOMATON), (org.eclipse.viatra.cep.core.metamodels.automaton.TypedTransition) t.get(POSITION_TRANSITION), (org.eclipse.viatra.cep.core.metamodels.events.ComplexEventPattern) t.get(POSITION_EVENTPATTERN));
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in tuple not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected ComplexNotTransitionMatch arrayToMatch(final Object[] match) {
    try {
    	return ComplexNotTransitionMatch.newMatch((org.eclipse.viatra.cep.core.metamodels.automaton.Automaton) match[POSITION_AUTOMATON], (org.eclipse.viatra.cep.core.metamodels.automaton.TypedTransition) match[POSITION_TRANSITION], (org.eclipse.viatra.cep.core.metamodels.events.ComplexEventPattern) match[POSITION_EVENTPATTERN]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected ComplexNotTransitionMatch arrayToMatchMutable(final Object[] match) {
    try {
    	return ComplexNotTransitionMatch.newMutableMatch((org.eclipse.viatra.cep.core.metamodels.automaton.Automaton) match[POSITION_AUTOMATON], (org.eclipse.viatra.cep.core.metamodels.automaton.TypedTransition) match[POSITION_TRANSITION], (org.eclipse.viatra.cep.core.metamodels.events.ComplexEventPattern) match[POSITION_EVENTPATTERN]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  /**
   * @return the singleton instance of the query specification of this pattern
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static IQuerySpecification<ComplexNotTransitionMatcher> querySpecification() throws IncQueryException {
    return ComplexNotTransitionQuerySpecification.instance();
  }
}
