package org.eclipse.viatra.cep.core.engine.compiler;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseMatcher;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.incquery.runtime.util.IncQueryLoggingUtil;
import org.eclipse.viatra.cep.core.engine.compiler.EpsilonTransitionMatch;
import org.eclipse.viatra.cep.core.engine.compiler.util.EpsilonTransitionQuerySpecification;
import org.eclipse.viatra.cep.core.metamodels.automaton.Automaton;
import org.eclipse.viatra.cep.core.metamodels.automaton.EpsilonTransition;
import org.eclipse.viatra.cep.core.metamodels.automaton.State;

/**
 * Generated pattern matcher API of the org.eclipse.viatra.cep.core.engine.compiler.epsilonTransition pattern,
 * providing pattern-specific query methods.
 * 
 * <p>Use the pattern matcher on a given model via {@link #on(IncQueryEngine)},
 * e.g. in conjunction with {@link IncQueryEngine#on(Notifier)}.
 * 
 * <p>Matches of the pattern will be represented as {@link EpsilonTransitionMatch}.
 * 
 * <p>Original source:
 * <code><pre>
 * pattern
 * epsilonTransition(automaton : Automaton, transition : EpsilonTransition, preState : State, postState : State) {
 * 	Automaton.states(automaton, preState);
 * 	Automaton.states(automaton, postState);
 * 	State.outTransitions(preState, transition);
 * 	State.inTransitions(postState, transition);
 * }
 * </pre></code>
 * 
 * @see EpsilonTransitionMatch
 * @see EpsilonTransitionProcessor
 * @see EpsilonTransitionQuerySpecification
 * 
 */
@SuppressWarnings("all")
public class EpsilonTransitionMatcher extends BaseMatcher<EpsilonTransitionMatch> {
  /**
   * Initializes the pattern matcher within an existing EMF-IncQuery engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing EMF-IncQuery engine in which this matcher will be created.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * 
   */
  public static EpsilonTransitionMatcher on(final IncQueryEngine engine) throws IncQueryException {
    // check if matcher already exists
    EpsilonTransitionMatcher matcher = engine.getExistingMatcher(querySpecification());
    if (matcher == null) {
    	matcher = new EpsilonTransitionMatcher(engine);
    	// do not have to "put" it into engine.matchers, reportMatcherInitialized() will take care of it
    }
    return matcher;
  }
  
  private final static int POSITION_AUTOMATON = 0;
  
  private final static int POSITION_TRANSITION = 1;
  
  private final static int POSITION_PRESTATE = 2;
  
  private final static int POSITION_POSTSTATE = 3;
  
  private final static Logger LOGGER = IncQueryLoggingUtil.getLogger(EpsilonTransitionMatcher.class);
  
  /**
   * Initializes the pattern matcher over a given EMF model root (recommended: Resource or ResourceSet).
   * If a pattern matcher is already constructed with the same root, only a light-weight reference is returned.
   * The scope of pattern matching will be the given EMF model root and below (see FAQ for more precise definition).
   * The match set will be incrementally refreshed upon updates from this scope.
   * <p>The matcher will be created within the managed {@link IncQueryEngine} belonging to the EMF model root, so
   * multiple matchers will reuse the same engine and benefit from increased performance and reduced memory footprint.
   * @param emfRoot the root of the EMF containment hierarchy where the pattern matcher will operate. Recommended: Resource or ResourceSet.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * @deprecated use {@link #on(IncQueryEngine)} instead, e.g. in conjunction with {@link IncQueryEngine#on(Notifier)}
   * 
   */
  @Deprecated
  public EpsilonTransitionMatcher(final Notifier emfRoot) throws IncQueryException {
    this(IncQueryEngine.on(emfRoot));
  }
  
  /**
   * Initializes the pattern matcher within an existing EMF-IncQuery engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing EMF-IncQuery engine in which this matcher will be created.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * @deprecated use {@link #on(IncQueryEngine)} instead
   * 
   */
  @Deprecated
  public EpsilonTransitionMatcher(final IncQueryEngine engine) throws IncQueryException {
    super(engine, querySpecification());
  }
  
  /**
   * Returns the set of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @param pTransition the fixed value of pattern parameter transition, or null if not bound.
   * @param pPreState the fixed value of pattern parameter preState, or null if not bound.
   * @param pPostState the fixed value of pattern parameter postState, or null if not bound.
   * @return matches represented as a EpsilonTransitionMatch object.
   * 
   */
  public Collection<EpsilonTransitionMatch> getAllMatches(final Automaton pAutomaton, final EpsilonTransition pTransition, final State pPreState, final State pPostState) {
    return rawGetAllMatches(new Object[]{pAutomaton, pTransition, pPreState, pPostState});
  }
  
  /**
   * Returns an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @param pTransition the fixed value of pattern parameter transition, or null if not bound.
   * @param pPreState the fixed value of pattern parameter preState, or null if not bound.
   * @param pPostState the fixed value of pattern parameter postState, or null if not bound.
   * @return a match represented as a EpsilonTransitionMatch object, or null if no match is found.
   * 
   */
  public EpsilonTransitionMatch getOneArbitraryMatch(final Automaton pAutomaton, final EpsilonTransition pTransition, final State pPreState, final State pPostState) {
    return rawGetOneArbitraryMatch(new Object[]{pAutomaton, pTransition, pPreState, pPostState});
  }
  
  /**
   * Indicates whether the given combination of specified pattern parameters constitute a valid pattern match,
   * under any possible substitution of the unspecified parameters (if any).
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @param pTransition the fixed value of pattern parameter transition, or null if not bound.
   * @param pPreState the fixed value of pattern parameter preState, or null if not bound.
   * @param pPostState the fixed value of pattern parameter postState, or null if not bound.
   * @return true if the input is a valid (partial) match of the pattern.
   * 
   */
  public boolean hasMatch(final Automaton pAutomaton, final EpsilonTransition pTransition, final State pPreState, final State pPostState) {
    return rawHasMatch(new Object[]{pAutomaton, pTransition, pPreState, pPostState});
  }
  
  /**
   * Returns the number of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @param pTransition the fixed value of pattern parameter transition, or null if not bound.
   * @param pPreState the fixed value of pattern parameter preState, or null if not bound.
   * @param pPostState the fixed value of pattern parameter postState, or null if not bound.
   * @return the number of pattern matches found.
   * 
   */
  public int countMatches(final Automaton pAutomaton, final EpsilonTransition pTransition, final State pPreState, final State pPostState) {
    return rawCountMatches(new Object[]{pAutomaton, pTransition, pPreState, pPostState});
  }
  
  /**
   * Executes the given processor on each match of the pattern that conforms to the given fixed values of some parameters.
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @param pTransition the fixed value of pattern parameter transition, or null if not bound.
   * @param pPreState the fixed value of pattern parameter preState, or null if not bound.
   * @param pPostState the fixed value of pattern parameter postState, or null if not bound.
   * @param processor the action that will process each pattern match.
   * 
   */
  public void forEachMatch(final Automaton pAutomaton, final EpsilonTransition pTransition, final State pPreState, final State pPostState, final IMatchProcessor<? super EpsilonTransitionMatch> processor) {
    rawForEachMatch(new Object[]{pAutomaton, pTransition, pPreState, pPostState}, processor);
  }
  
  /**
   * Executes the given processor on an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @param pTransition the fixed value of pattern parameter transition, or null if not bound.
   * @param pPreState the fixed value of pattern parameter preState, or null if not bound.
   * @param pPostState the fixed value of pattern parameter postState, or null if not bound.
   * @param processor the action that will process the selected match.
   * @return true if the pattern has at least one match with the given parameter values, false if the processor was not invoked
   * 
   */
  public boolean forOneArbitraryMatch(final Automaton pAutomaton, final EpsilonTransition pTransition, final State pPreState, final State pPostState, final IMatchProcessor<? super EpsilonTransitionMatch> processor) {
    return rawForOneArbitraryMatch(new Object[]{pAutomaton, pTransition, pPreState, pPostState}, processor);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pAutomaton the fixed value of pattern parameter automaton, or null if not bound.
   * @param pTransition the fixed value of pattern parameter transition, or null if not bound.
   * @param pPreState the fixed value of pattern parameter preState, or null if not bound.
   * @param pPostState the fixed value of pattern parameter postState, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public EpsilonTransitionMatch newMatch(final Automaton pAutomaton, final EpsilonTransition pTransition, final State pPreState, final State pPostState) {
    return EpsilonTransitionMatch.newMatch(pAutomaton, pTransition, pPreState, pPostState);
  }
  
  /**
   * Retrieve the set of values that occur in matches for automaton.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<Automaton> rawAccumulateAllValuesOfautomaton(final Object[] parameters) {
    Set<Automaton> results = new HashSet<Automaton>();
    rawAccumulateAllValues(POSITION_AUTOMATON, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for automaton.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Automaton> getAllValuesOfautomaton() {
    return rawAccumulateAllValuesOfautomaton(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for automaton.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Automaton> getAllValuesOfautomaton(final EpsilonTransitionMatch partialMatch) {
    return rawAccumulateAllValuesOfautomaton(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for automaton.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Automaton> getAllValuesOfautomaton(final EpsilonTransition pTransition, final State pPreState, final State pPostState) {
    return rawAccumulateAllValuesOfautomaton(new Object[]{
    null, 
    pTransition, 
    pPreState, 
    pPostState
    });
  }
  
  /**
   * Retrieve the set of values that occur in matches for transition.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<EpsilonTransition> rawAccumulateAllValuesOftransition(final Object[] parameters) {
    Set<EpsilonTransition> results = new HashSet<EpsilonTransition>();
    rawAccumulateAllValues(POSITION_TRANSITION, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for transition.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<EpsilonTransition> getAllValuesOftransition() {
    return rawAccumulateAllValuesOftransition(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for transition.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<EpsilonTransition> getAllValuesOftransition(final EpsilonTransitionMatch partialMatch) {
    return rawAccumulateAllValuesOftransition(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for transition.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<EpsilonTransition> getAllValuesOftransition(final Automaton pAutomaton, final State pPreState, final State pPostState) {
    return rawAccumulateAllValuesOftransition(new Object[]{
    pAutomaton, 
    null, 
    pPreState, 
    pPostState
    });
  }
  
  /**
   * Retrieve the set of values that occur in matches for preState.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<State> rawAccumulateAllValuesOfpreState(final Object[] parameters) {
    Set<State> results = new HashSet<State>();
    rawAccumulateAllValues(POSITION_PRESTATE, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for preState.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<State> getAllValuesOfpreState() {
    return rawAccumulateAllValuesOfpreState(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for preState.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<State> getAllValuesOfpreState(final EpsilonTransitionMatch partialMatch) {
    return rawAccumulateAllValuesOfpreState(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for preState.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<State> getAllValuesOfpreState(final Automaton pAutomaton, final EpsilonTransition pTransition, final State pPostState) {
    return rawAccumulateAllValuesOfpreState(new Object[]{
    pAutomaton, 
    pTransition, 
    null, 
    pPostState
    });
  }
  
  /**
   * Retrieve the set of values that occur in matches for postState.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<State> rawAccumulateAllValuesOfpostState(final Object[] parameters) {
    Set<State> results = new HashSet<State>();
    rawAccumulateAllValues(POSITION_POSTSTATE, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for postState.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<State> getAllValuesOfpostState() {
    return rawAccumulateAllValuesOfpostState(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for postState.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<State> getAllValuesOfpostState(final EpsilonTransitionMatch partialMatch) {
    return rawAccumulateAllValuesOfpostState(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for postState.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<State> getAllValuesOfpostState(final Automaton pAutomaton, final EpsilonTransition pTransition, final State pPreState) {
    return rawAccumulateAllValuesOfpostState(new Object[]{
    pAutomaton, 
    pTransition, 
    pPreState, 
    null
    });
  }
  
  @Override
  protected EpsilonTransitionMatch tupleToMatch(final Tuple t) {
    try {
    	return EpsilonTransitionMatch.newMatch((org.eclipse.viatra.cep.core.metamodels.automaton.Automaton) t.get(POSITION_AUTOMATON), (org.eclipse.viatra.cep.core.metamodels.automaton.EpsilonTransition) t.get(POSITION_TRANSITION), (org.eclipse.viatra.cep.core.metamodels.automaton.State) t.get(POSITION_PRESTATE), (org.eclipse.viatra.cep.core.metamodels.automaton.State) t.get(POSITION_POSTSTATE));
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in tuple not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected EpsilonTransitionMatch arrayToMatch(final Object[] match) {
    try {
    	return EpsilonTransitionMatch.newMatch((org.eclipse.viatra.cep.core.metamodels.automaton.Automaton) match[POSITION_AUTOMATON], (org.eclipse.viatra.cep.core.metamodels.automaton.EpsilonTransition) match[POSITION_TRANSITION], (org.eclipse.viatra.cep.core.metamodels.automaton.State) match[POSITION_PRESTATE], (org.eclipse.viatra.cep.core.metamodels.automaton.State) match[POSITION_POSTSTATE]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected EpsilonTransitionMatch arrayToMatchMutable(final Object[] match) {
    try {
    	return EpsilonTransitionMatch.newMutableMatch((org.eclipse.viatra.cep.core.metamodels.automaton.Automaton) match[POSITION_AUTOMATON], (org.eclipse.viatra.cep.core.metamodels.automaton.EpsilonTransition) match[POSITION_TRANSITION], (org.eclipse.viatra.cep.core.metamodels.automaton.State) match[POSITION_PRESTATE], (org.eclipse.viatra.cep.core.metamodels.automaton.State) match[POSITION_POSTSTATE]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  /**
   * @return the singleton instance of the query specification of this pattern
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static IQuerySpecification<EpsilonTransitionMatcher> querySpecification() throws IncQueryException {
    return EpsilonTransitionQuerySpecification.instance();
  }
}
