package org.eclipse.viatra.cep.core.engine.compiler;

import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedPatternGroup;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.viatra.cep.core.engine.compiler.AndPatternMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.AtomicEventPatternMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.ComplexAndTransitionMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.ComplexFollowsTransitionMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.ComplexNotTransitionMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.ComplexOrTransitionMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.FollowsPatternMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.NegativeTransitionMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.NonUnfoldedNotTransitionMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.NotPatternMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.OrPatternMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.TranslatedEventPatternMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.util.AndPatternQuerySpecification;
import org.eclipse.viatra.cep.core.engine.compiler.util.AtomicEventPatternQuerySpecification;
import org.eclipse.viatra.cep.core.engine.compiler.util.ComplexAndTransitionQuerySpecification;
import org.eclipse.viatra.cep.core.engine.compiler.util.ComplexFollowsTransitionQuerySpecification;
import org.eclipse.viatra.cep.core.engine.compiler.util.ComplexNotTransitionQuerySpecification;
import org.eclipse.viatra.cep.core.engine.compiler.util.ComplexOrTransitionQuerySpecification;
import org.eclipse.viatra.cep.core.engine.compiler.util.FollowsPatternQuerySpecification;
import org.eclipse.viatra.cep.core.engine.compiler.util.NegativeTransitionQuerySpecification;
import org.eclipse.viatra.cep.core.engine.compiler.util.NonUnfoldedNotTransitionQuerySpecification;
import org.eclipse.viatra.cep.core.engine.compiler.util.NotPatternQuerySpecification;
import org.eclipse.viatra.cep.core.engine.compiler.util.OrPatternQuerySpecification;
import org.eclipse.viatra.cep.core.engine.compiler.util.TranslatedEventPatternQuerySpecification;

/**
 * A pattern group formed of all patterns defined in mappingPatterns.eiq.
 * 
 * <p>Use the static instance as any {@link org.eclipse.incquery.runtime.api.IPatternGroup}, to conveniently prepare
 * an EMF-IncQuery engine for matching all patterns originally defined in file mappingPatterns.eiq,
 * in order to achieve better performance than one-by-one on-demand matcher initialization.
 * 
 * <p> From package org.eclipse.viatra.cep.core.engine.compiler, the group contains the definition of the following patterns: <ul>
 * <li>translatedEventPattern</li>
 * <li>atomicEventPattern</li>
 * <li>complexPattern</li>
 * <li>followsPattern</li>
 * <li>orPattern</li>
 * <li>andPattern</li>
 * <li>notPattern</li>
 * <li>complexTransition</li>
 * <li>negativeTransition</li>
 * <li>complexFollowsTransition</li>
 * <li>complexOrTransition</li>
 * <li>complexAndTransition</li>
 * <li>nonUnfoldedNotTransition</li>
 * <li>complexNotTransition</li>
 * </ul>
 * 
 * @see IPatternGroup
 * 
 */
@SuppressWarnings("all")
public final class MappingPatterns extends BaseGeneratedPatternGroup {
  /**
   * Access the pattern group.
   * 
   * @return the singleton instance of the group
   * @throws IncQueryException if there was an error loading the generated code of pattern specifications
   * 
   */
  public static MappingPatterns instance() throws IncQueryException {
    if (INSTANCE == null) {
    	INSTANCE = new MappingPatterns();
    }
    return INSTANCE;
  }
  
  private static MappingPatterns INSTANCE;
  
  private MappingPatterns() throws IncQueryException {
    querySpecifications.add(TranslatedEventPatternQuerySpecification.instance());
    querySpecifications.add(AtomicEventPatternQuerySpecification.instance());
    querySpecifications.add(FollowsPatternQuerySpecification.instance());
    querySpecifications.add(OrPatternQuerySpecification.instance());
    querySpecifications.add(AndPatternQuerySpecification.instance());
    querySpecifications.add(NotPatternQuerySpecification.instance());
    querySpecifications.add(NegativeTransitionQuerySpecification.instance());
    querySpecifications.add(ComplexFollowsTransitionQuerySpecification.instance());
    querySpecifications.add(ComplexOrTransitionQuerySpecification.instance());
    querySpecifications.add(ComplexAndTransitionQuerySpecification.instance());
    querySpecifications.add(NonUnfoldedNotTransitionQuerySpecification.instance());
    querySpecifications.add(ComplexNotTransitionQuerySpecification.instance());
  }
  
  public TranslatedEventPatternQuerySpecification getTranslatedEventPattern() throws IncQueryException {
    return TranslatedEventPatternQuerySpecification.instance();
  }
  
  public TranslatedEventPatternMatcher getTranslatedEventPattern(final IncQueryEngine engine) throws IncQueryException {
    return TranslatedEventPatternMatcher.on(engine);
  }
  
  public AtomicEventPatternQuerySpecification getAtomicEventPattern() throws IncQueryException {
    return AtomicEventPatternQuerySpecification.instance();
  }
  
  public AtomicEventPatternMatcher getAtomicEventPattern(final IncQueryEngine engine) throws IncQueryException {
    return AtomicEventPatternMatcher.on(engine);
  }
  
  public FollowsPatternQuerySpecification getFollowsPattern() throws IncQueryException {
    return FollowsPatternQuerySpecification.instance();
  }
  
  public FollowsPatternMatcher getFollowsPattern(final IncQueryEngine engine) throws IncQueryException {
    return FollowsPatternMatcher.on(engine);
  }
  
  public OrPatternQuerySpecification getOrPattern() throws IncQueryException {
    return OrPatternQuerySpecification.instance();
  }
  
  public OrPatternMatcher getOrPattern(final IncQueryEngine engine) throws IncQueryException {
    return OrPatternMatcher.on(engine);
  }
  
  public AndPatternQuerySpecification getAndPattern() throws IncQueryException {
    return AndPatternQuerySpecification.instance();
  }
  
  public AndPatternMatcher getAndPattern(final IncQueryEngine engine) throws IncQueryException {
    return AndPatternMatcher.on(engine);
  }
  
  public NotPatternQuerySpecification getNotPattern() throws IncQueryException {
    return NotPatternQuerySpecification.instance();
  }
  
  public NotPatternMatcher getNotPattern(final IncQueryEngine engine) throws IncQueryException {
    return NotPatternMatcher.on(engine);
  }
  
  public NegativeTransitionQuerySpecification getNegativeTransition() throws IncQueryException {
    return NegativeTransitionQuerySpecification.instance();
  }
  
  public NegativeTransitionMatcher getNegativeTransition(final IncQueryEngine engine) throws IncQueryException {
    return NegativeTransitionMatcher.on(engine);
  }
  
  public ComplexFollowsTransitionQuerySpecification getComplexFollowsTransition() throws IncQueryException {
    return ComplexFollowsTransitionQuerySpecification.instance();
  }
  
  public ComplexFollowsTransitionMatcher getComplexFollowsTransition(final IncQueryEngine engine) throws IncQueryException {
    return ComplexFollowsTransitionMatcher.on(engine);
  }
  
  public ComplexOrTransitionQuerySpecification getComplexOrTransition() throws IncQueryException {
    return ComplexOrTransitionQuerySpecification.instance();
  }
  
  public ComplexOrTransitionMatcher getComplexOrTransition(final IncQueryEngine engine) throws IncQueryException {
    return ComplexOrTransitionMatcher.on(engine);
  }
  
  public ComplexAndTransitionQuerySpecification getComplexAndTransition() throws IncQueryException {
    return ComplexAndTransitionQuerySpecification.instance();
  }
  
  public ComplexAndTransitionMatcher getComplexAndTransition(final IncQueryEngine engine) throws IncQueryException {
    return ComplexAndTransitionMatcher.on(engine);
  }
  
  public NonUnfoldedNotTransitionQuerySpecification getNonUnfoldedNotTransition() throws IncQueryException {
    return NonUnfoldedNotTransitionQuerySpecification.instance();
  }
  
  public NonUnfoldedNotTransitionMatcher getNonUnfoldedNotTransition(final IncQueryEngine engine) throws IncQueryException {
    return NonUnfoldedNotTransitionMatcher.on(engine);
  }
  
  public ComplexNotTransitionQuerySpecification getComplexNotTransition() throws IncQueryException {
    return ComplexNotTransitionQuerySpecification.instance();
  }
  
  public ComplexNotTransitionMatcher getComplexNotTransition(final IncQueryEngine engine) throws IncQueryException {
    return ComplexNotTransitionMatcher.on(engine);
  }
}
