package org.eclipse.viatra.cep.core.engine.compiler;

import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedPatternGroup;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.viatra.cep.core.engine.compiler.EpsilonTransitionMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.EquivalentStatesMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.EquivalentTransitionsMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.SameBooleanTransitionTypeMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.util.EpsilonTransitionQuerySpecification;
import org.eclipse.viatra.cep.core.engine.compiler.util.EquivalentStatesQuerySpecification;
import org.eclipse.viatra.cep.core.engine.compiler.util.EquivalentTransitionsQuerySpecification;
import org.eclipse.viatra.cep.core.engine.compiler.util.SameBooleanTransitionTypeQuerySpecification;

/**
 * A pattern group formed of all patterns defined in optimizationPatterns.eiq.
 * 
 * <p>Use the static instance as any {@link org.eclipse.incquery.runtime.api.IPatternGroup}, to conveniently prepare
 * an EMF-IncQuery engine for matching all patterns originally defined in file optimizationPatterns.eiq,
 * in order to achieve better performance than one-by-one on-demand matcher initialization.
 * 
 * <p> From package org.eclipse.viatra.cep.core.engine.compiler, the group contains the definition of the following patterns: <ul>
 * <li>epsilonTransition</li>
 * <li>sameBooleanTransitionType</li>
 * <li>equivalentTransitions</li>
 * <li>equivalentStates</li>
 * </ul>
 * 
 * @see IPatternGroup
 * 
 */
@SuppressWarnings("all")
public final class OptimizationPatterns extends BaseGeneratedPatternGroup {
  /**
   * Access the pattern group.
   * 
   * @return the singleton instance of the group
   * @throws IncQueryException if there was an error loading the generated code of pattern specifications
   * 
   */
  public static OptimizationPatterns instance() throws IncQueryException {
    if (INSTANCE == null) {
    	INSTANCE = new OptimizationPatterns();
    }
    return INSTANCE;
  }
  
  private static OptimizationPatterns INSTANCE;
  
  private OptimizationPatterns() throws IncQueryException {
    querySpecifications.add(EpsilonTransitionQuerySpecification.instance());
    querySpecifications.add(SameBooleanTransitionTypeQuerySpecification.instance());
    querySpecifications.add(EquivalentTransitionsQuerySpecification.instance());
    querySpecifications.add(EquivalentStatesQuerySpecification.instance());
  }
  
  public EpsilonTransitionQuerySpecification getEpsilonTransition() throws IncQueryException {
    return EpsilonTransitionQuerySpecification.instance();
  }
  
  public EpsilonTransitionMatcher getEpsilonTransition(final IncQueryEngine engine) throws IncQueryException {
    return EpsilonTransitionMatcher.on(engine);
  }
  
  public SameBooleanTransitionTypeQuerySpecification getSameBooleanTransitionType() throws IncQueryException {
    return SameBooleanTransitionTypeQuerySpecification.instance();
  }
  
  public SameBooleanTransitionTypeMatcher getSameBooleanTransitionType(final IncQueryEngine engine) throws IncQueryException {
    return SameBooleanTransitionTypeMatcher.on(engine);
  }
  
  public EquivalentTransitionsQuerySpecification getEquivalentTransitions() throws IncQueryException {
    return EquivalentTransitionsQuerySpecification.instance();
  }
  
  public EquivalentTransitionsMatcher getEquivalentTransitions(final IncQueryEngine engine) throws IncQueryException {
    return EquivalentTransitionsMatcher.on(engine);
  }
  
  public EquivalentStatesQuerySpecification getEquivalentStates() throws IncQueryException {
    return EquivalentStatesQuerySpecification.instance();
  }
  
  public EquivalentStatesMatcher getEquivalentStates(final IncQueryEngine engine) throws IncQueryException {
    return EquivalentStatesMatcher.on(engine);
  }
}
