package org.eclipse.viatra.cep.core.engine.compiler;

import java.util.Arrays;
import java.util.List;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.impl.BasePatternMatch;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.viatra.cep.core.engine.compiler.util.SameBooleanTransitionTypeQuerySpecification;
import org.eclipse.viatra.cep.core.metamodels.automaton.TypedTransition;

/**
 * Pattern-specific match representation of the org.eclipse.viatra.cep.core.engine.compiler.sameBooleanTransitionType pattern,
 * to be used in conjunction with {@link SameBooleanTransitionTypeMatcher}.
 * 
 * <p>Class fields correspond to parameters of the pattern. Fields with value null are considered unassigned.
 * Each instance is a (possibly partial) substitution of pattern parameters,
 * usable to represent a match of the pattern in the result of a query,
 * or to specify the bound (fixed) input parameters when issuing a query.
 * 
 * @see SameBooleanTransitionTypeMatcher
 * @see SameBooleanTransitionTypeProcessor
 * 
 */
@SuppressWarnings("all")
public abstract class SameBooleanTransitionTypeMatch extends BasePatternMatch {
  private TypedTransition fTransition1;
  
  private TypedTransition fTransition2;
  
  private static List<String> parameterNames = makeImmutableList("transition1", "transition2");
  
  private SameBooleanTransitionTypeMatch(final TypedTransition pTransition1, final TypedTransition pTransition2) {
    this.fTransition1 = pTransition1;
    this.fTransition2 = pTransition2;
  }
  
  @Override
  public Object get(final String parameterName) {
    if ("transition1".equals(parameterName)) return this.fTransition1;
    if ("transition2".equals(parameterName)) return this.fTransition2;
    return null;
  }
  
  public TypedTransition getTransition1() {
    return this.fTransition1;
  }
  
  public TypedTransition getTransition2() {
    return this.fTransition2;
  }
  
  @Override
  public boolean set(final String parameterName, final Object newValue) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    if ("transition1".equals(parameterName) ) {
    	this.fTransition1 = (org.eclipse.viatra.cep.core.metamodels.automaton.TypedTransition) newValue;
    	return true;
    }
    if ("transition2".equals(parameterName) ) {
    	this.fTransition2 = (org.eclipse.viatra.cep.core.metamodels.automaton.TypedTransition) newValue;
    	return true;
    }
    return false;
  }
  
  public void setTransition1(final TypedTransition pTransition1) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fTransition1 = pTransition1;
  }
  
  public void setTransition2(final TypedTransition pTransition2) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fTransition2 = pTransition2;
  }
  
  @Override
  public String patternName() {
    return "org.eclipse.viatra.cep.core.engine.compiler.sameBooleanTransitionType";
  }
  
  @Override
  public List<String> parameterNames() {
    return SameBooleanTransitionTypeMatch.parameterNames;
  }
  
  @Override
  public Object[] toArray() {
    return new Object[]{fTransition1, fTransition2};
  }
  
  @Override
  public SameBooleanTransitionTypeMatch toImmutable() {
    return isMutable() ? newMatch(fTransition1, fTransition2) : this;
  }
  
  @Override
  public String prettyPrint() {
    StringBuilder result = new StringBuilder();
    result.append("\"transition1\"=" + prettyPrintValue(fTransition1) + ", ");
    
    result.append("\"transition2\"=" + prettyPrintValue(fTransition2)
    );
    return result.toString();
  }
  
  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((fTransition1 == null) ? 0 : fTransition1.hashCode());
    result = prime * result + ((fTransition2 == null) ? 0 : fTransition2.hashCode());
    return result;
  }
  
  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
    	return true;
    if (!(obj instanceof SameBooleanTransitionTypeMatch)) { // this should be infrequent
    	if (obj == null) {
    		return false;
    	}
    	if (!(obj instanceof IPatternMatch)) {
    		return false;
    	}
    	IPatternMatch otherSig  = (IPatternMatch) obj;
    	if (!specification().equals(otherSig.specification()))
    		return false;
    	return Arrays.deepEquals(toArray(), otherSig.toArray());
    }
    SameBooleanTransitionTypeMatch other = (SameBooleanTransitionTypeMatch) obj;
    if (fTransition1 == null) {if (other.fTransition1 != null) return false;}
    else if (!fTransition1.equals(other.fTransition1)) return false;
    if (fTransition2 == null) {if (other.fTransition2 != null) return false;}
    else if (!fTransition2.equals(other.fTransition2)) return false;
    return true;
  }
  
  @Override
  public SameBooleanTransitionTypeQuerySpecification specification() {
    try {
    	return SameBooleanTransitionTypeQuerySpecification.instance();
    } catch (IncQueryException ex) {
     	// This cannot happen, as the match object can only be instantiated if the query specification exists
     	throw new IllegalStateException (ex);
    }
  }
  
  /**
   * Returns an empty, mutable match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @return the empty match.
   * 
   */
  public static SameBooleanTransitionTypeMatch newEmptyMatch() {
    return new Mutable(null, null);
  }
  
  /**
   * Returns a mutable (partial) match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @param pTransition1 the fixed value of pattern parameter transition1, or null if not bound.
   * @param pTransition2 the fixed value of pattern parameter transition2, or null if not bound.
   * @return the new, mutable (partial) match object.
   * 
   */
  public static SameBooleanTransitionTypeMatch newMutableMatch(final TypedTransition pTransition1, final TypedTransition pTransition2) {
    return new Mutable(pTransition1, pTransition2);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pTransition1 the fixed value of pattern parameter transition1, or null if not bound.
   * @param pTransition2 the fixed value of pattern parameter transition2, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public static SameBooleanTransitionTypeMatch newMatch(final TypedTransition pTransition1, final TypedTransition pTransition2) {
    return new Immutable(pTransition1, pTransition2);
  }
  
  private static final class Mutable extends SameBooleanTransitionTypeMatch {
    Mutable(final TypedTransition pTransition1, final TypedTransition pTransition2) {
      super(pTransition1, pTransition2);
    }
    
    @Override
    public boolean isMutable() {
      return true;
    }
  }
  
  private static final class Immutable extends SameBooleanTransitionTypeMatch {
    Immutable(final TypedTransition pTransition1, final TypedTransition pTransition2) {
      super(pTransition1, pTransition2);
    }
    
    @Override
    public boolean isMutable() {
      return false;
    }
  }
}
