package org.eclipse.viatra.cep.core.engine.compiler;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseMatcher;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.incquery.runtime.util.IncQueryLoggingUtil;
import org.eclipse.viatra.cep.core.engine.compiler.TranslatedEventPatternMatch;
import org.eclipse.viatra.cep.core.engine.compiler.util.TranslatedEventPatternQuerySpecification;
import org.eclipse.viatra.cep.core.metamodels.events.EventPattern;

/**
 * Generated pattern matcher API of the org.eclipse.viatra.cep.core.engine.compiler.translatedEventPattern pattern,
 * providing pattern-specific query methods.
 * 
 * <p>Use the pattern matcher on a given model via {@link #on(IncQueryEngine)},
 * e.g. in conjunction with {@link IncQueryEngine#on(Notifier)}.
 * 
 * <p>Matches of the pattern will be represented as {@link TranslatedEventPatternMatch}.
 * 
 * <p>Original source:
 * <code><pre>
 * pattern translatedEventPattern(eventPattern : EventPattern) {
 * 	TraceModel.traces(_, trace);
 * 	Trace.eventPattern(trace, eventPattern);
 * }
 * </pre></code>
 * 
 * @see TranslatedEventPatternMatch
 * @see TranslatedEventPatternProcessor
 * @see TranslatedEventPatternQuerySpecification
 * 
 */
@SuppressWarnings("all")
public class TranslatedEventPatternMatcher extends BaseMatcher<TranslatedEventPatternMatch> {
  /**
   * Initializes the pattern matcher within an existing EMF-IncQuery engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing EMF-IncQuery engine in which this matcher will be created.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * 
   */
  public static TranslatedEventPatternMatcher on(final IncQueryEngine engine) throws IncQueryException {
    // check if matcher already exists
    TranslatedEventPatternMatcher matcher = engine.getExistingMatcher(querySpecification());
    if (matcher == null) {
    	matcher = new TranslatedEventPatternMatcher(engine);
    	// do not have to "put" it into engine.matchers, reportMatcherInitialized() will take care of it
    }
    return matcher;
  }
  
  private final static int POSITION_EVENTPATTERN = 0;
  
  private final static Logger LOGGER = IncQueryLoggingUtil.getLogger(TranslatedEventPatternMatcher.class);
  
  /**
   * Initializes the pattern matcher over a given EMF model root (recommended: Resource or ResourceSet).
   * If a pattern matcher is already constructed with the same root, only a light-weight reference is returned.
   * The scope of pattern matching will be the given EMF model root and below (see FAQ for more precise definition).
   * The match set will be incrementally refreshed upon updates from this scope.
   * <p>The matcher will be created within the managed {@link IncQueryEngine} belonging to the EMF model root, so
   * multiple matchers will reuse the same engine and benefit from increased performance and reduced memory footprint.
   * @param emfRoot the root of the EMF containment hierarchy where the pattern matcher will operate. Recommended: Resource or ResourceSet.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * @deprecated use {@link #on(IncQueryEngine)} instead, e.g. in conjunction with {@link IncQueryEngine#on(Notifier)}
   * 
   */
  @Deprecated
  public TranslatedEventPatternMatcher(final Notifier emfRoot) throws IncQueryException {
    this(IncQueryEngine.on(emfRoot));
  }
  
  /**
   * Initializes the pattern matcher within an existing EMF-IncQuery engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing EMF-IncQuery engine in which this matcher will be created.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * @deprecated use {@link #on(IncQueryEngine)} instead
   * 
   */
  @Deprecated
  public TranslatedEventPatternMatcher(final IncQueryEngine engine) throws IncQueryException {
    super(engine, querySpecification());
  }
  
  /**
   * Returns the set of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pEventPattern the fixed value of pattern parameter eventPattern, or null if not bound.
   * @return matches represented as a TranslatedEventPatternMatch object.
   * 
   */
  public Collection<TranslatedEventPatternMatch> getAllMatches(final EventPattern pEventPattern) {
    return rawGetAllMatches(new Object[]{pEventPattern});
  }
  
  /**
   * Returns an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pEventPattern the fixed value of pattern parameter eventPattern, or null if not bound.
   * @return a match represented as a TranslatedEventPatternMatch object, or null if no match is found.
   * 
   */
  public TranslatedEventPatternMatch getOneArbitraryMatch(final EventPattern pEventPattern) {
    return rawGetOneArbitraryMatch(new Object[]{pEventPattern});
  }
  
  /**
   * Indicates whether the given combination of specified pattern parameters constitute a valid pattern match,
   * under any possible substitution of the unspecified parameters (if any).
   * @param pEventPattern the fixed value of pattern parameter eventPattern, or null if not bound.
   * @return true if the input is a valid (partial) match of the pattern.
   * 
   */
  public boolean hasMatch(final EventPattern pEventPattern) {
    return rawHasMatch(new Object[]{pEventPattern});
  }
  
  /**
   * Returns the number of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pEventPattern the fixed value of pattern parameter eventPattern, or null if not bound.
   * @return the number of pattern matches found.
   * 
   */
  public int countMatches(final EventPattern pEventPattern) {
    return rawCountMatches(new Object[]{pEventPattern});
  }
  
  /**
   * Executes the given processor on each match of the pattern that conforms to the given fixed values of some parameters.
   * @param pEventPattern the fixed value of pattern parameter eventPattern, or null if not bound.
   * @param processor the action that will process each pattern match.
   * 
   */
  public void forEachMatch(final EventPattern pEventPattern, final IMatchProcessor<? super TranslatedEventPatternMatch> processor) {
    rawForEachMatch(new Object[]{pEventPattern}, processor);
  }
  
  /**
   * Executes the given processor on an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pEventPattern the fixed value of pattern parameter eventPattern, or null if not bound.
   * @param processor the action that will process the selected match.
   * @return true if the pattern has at least one match with the given parameter values, false if the processor was not invoked
   * 
   */
  public boolean forOneArbitraryMatch(final EventPattern pEventPattern, final IMatchProcessor<? super TranslatedEventPatternMatch> processor) {
    return rawForOneArbitraryMatch(new Object[]{pEventPattern}, processor);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pEventPattern the fixed value of pattern parameter eventPattern, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public TranslatedEventPatternMatch newMatch(final EventPattern pEventPattern) {
    return TranslatedEventPatternMatch.newMatch(pEventPattern);
  }
  
  /**
   * Retrieve the set of values that occur in matches for eventPattern.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<EventPattern> rawAccumulateAllValuesOfeventPattern(final Object[] parameters) {
    Set<EventPattern> results = new HashSet<EventPattern>();
    rawAccumulateAllValues(POSITION_EVENTPATTERN, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for eventPattern.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<EventPattern> getAllValuesOfeventPattern() {
    return rawAccumulateAllValuesOfeventPattern(emptyArray());
  }
  
  @Override
  protected TranslatedEventPatternMatch tupleToMatch(final Tuple t) {
    try {
    	return TranslatedEventPatternMatch.newMatch((org.eclipse.viatra.cep.core.metamodels.events.EventPattern) t.get(POSITION_EVENTPATTERN));
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in tuple not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected TranslatedEventPatternMatch arrayToMatch(final Object[] match) {
    try {
    	return TranslatedEventPatternMatch.newMatch((org.eclipse.viatra.cep.core.metamodels.events.EventPattern) match[POSITION_EVENTPATTERN]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected TranslatedEventPatternMatch arrayToMatchMutable(final Object[] match) {
    try {
    	return TranslatedEventPatternMatch.newMutableMatch((org.eclipse.viatra.cep.core.metamodels.events.EventPattern) match[POSITION_EVENTPATTERN]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  /**
   * @return the singleton instance of the query specification of this pattern
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static IQuerySpecification<TranslatedEventPatternMatcher> querySpecification() throws IncQueryException {
    return TranslatedEventPatternQuerySpecification.instance();
  }
}
