/**
 * Copyright (c) 2004-2015, Istvan David, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * Istvan David - initial API and implementation
 */
package org.eclipse.viatra.cep.core.engine.compiler.rules;

import com.google.common.base.Objects;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.impl.BaseMatcher;
import org.eclipse.incquery.runtime.api.impl.BasePatternMatch;
import org.eclipse.viatra.cep.core.engine.compiler.AtomicEventPatternMatch;
import org.eclipse.viatra.cep.core.engine.compiler.AtomicEventPatternMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.rules.MappingRules;
import org.eclipse.viatra.cep.core.metamodels.automaton.Automaton;
import org.eclipse.viatra.cep.core.metamodels.automaton.FinalState;
import org.eclipse.viatra.cep.core.metamodels.automaton.Guard;
import org.eclipse.viatra.cep.core.metamodels.automaton.InitState;
import org.eclipse.viatra.cep.core.metamodels.automaton.InternalModel;
import org.eclipse.viatra.cep.core.metamodels.automaton.State;
import org.eclipse.viatra.cep.core.metamodels.automaton.TypedTransition;
import org.eclipse.viatra.cep.core.metamodels.events.AtomicEventPattern;
import org.eclipse.viatra.cep.core.metamodels.trace.TraceModel;
import org.eclipse.viatra.emf.runtime.rules.batch.BatchTransformationRule;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function0;

@SuppressWarnings("all")
public class AtomicMappingRules extends MappingRules {
  public AtomicMappingRules(final InternalModel internalModel, final TraceModel traceModel) {
    super(internalModel, traceModel);
  }
  
  @Override
  public List<? extends BatchTransformationRule<? extends BasePatternMatch, ? extends BaseMatcher<? extends BasePatternMatch>>> getAllRules() {
    return Collections.<BatchTransformationRule<? extends BasePatternMatch, ? extends BaseMatcher<? extends BasePatternMatch>>>unmodifiableList(CollectionLiterals.<BatchTransformationRule<? extends BasePatternMatch, ? extends BaseMatcher<? extends BasePatternMatch>>>newArrayList(this.atomicPattern2AutomatonRule));
  }
  
  /**
   * Transformation rule to compile {@link AtomicEventPattern}s to {@link Automaton}.
   */
  private final BatchTransformationRule<AtomicEventPatternMatch, AtomicEventPatternMatcher> atomicPattern2AutomatonRule = new Function0<BatchTransformationRule<AtomicEventPatternMatch, AtomicEventPatternMatcher>>() {
    public BatchTransformationRule<AtomicEventPatternMatch, AtomicEventPatternMatcher> apply() {
      try {
        IQuerySpecification<AtomicEventPatternMatcher> _querySpecification = AtomicEventPatternMatcher.querySpecification();
        final IMatchProcessor<AtomicEventPatternMatch> _function = new IMatchProcessor<AtomicEventPatternMatch>() {
          @Override
          public void process(final AtomicEventPatternMatch it) {
            AtomicEventPattern _eventPattern = it.getEventPattern();
            final Automaton mappedAutomaton = AtomicMappingRules.this.checkForMappedAutomaton(_eventPattern);
            boolean _notEquals = (!Objects.equal(mappedAutomaton, null));
            if (_notEquals) {
              AtomicEventPattern _eventPattern_1 = it.getEventPattern();
              AtomicMappingRules.this.createTrace(_eventPattern_1, mappedAutomaton);
              return;
            }
            AtomicEventPattern _eventPattern_2 = it.getEventPattern();
            Automaton automaton = AtomicMappingRules.this.initializeAutomaton(_eventPattern_2);
            TypedTransition transition = AtomicMappingRules.this.automatonFactory.createTypedTransition();
            Guard guard = AtomicMappingRules.this.automatonFactory.createGuard();
            AtomicEventPattern _eventPattern_3 = it.getEventPattern();
            guard.setEventType(_eventPattern_3);
            EList<Guard> _guards = transition.getGuards();
            _guards.add(guard);
            InitState _initialState = automaton.getInitialState();
            transition.setPreState(_initialState);
            final FinalState finalState = AtomicMappingRules.this.automatonFactory.createFinalState();
            EList<State> _states = automaton.getStates();
            _states.add(finalState);
            transition.setPostState(finalState);
            AtomicEventPattern _eventPattern_4 = it.getEventPattern();
            AtomicMappingRules.this.createTrace(_eventPattern_4, automaton);
          }
        };
        BatchTransformationRule<AtomicEventPatternMatch, AtomicEventPatternMatcher> _createRule = AtomicMappingRules.this.ruleFactory.<AtomicEventPatternMatch, AtomicEventPatternMatcher>createRule(_querySpecification, _function);
        return _createRule;
      } catch (Throwable _e) {
        throw Exceptions.sneakyThrow(_e);
      }
    }
  }.apply();
}
