package org.eclipse.viatra.cep.core.engine.compiler.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.viatra.cep.core.engine.compiler.AtomicEventPatternMatch;
import org.eclipse.viatra.cep.core.metamodels.events.AtomicEventPattern;

/**
 * A match processor tailored for the org.eclipse.viatra.cep.core.engine.compiler.atomicEventPattern pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class AtomicEventPatternProcessor implements IMatchProcessor<AtomicEventPatternMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pEventPattern the value of pattern parameter eventPattern in the currently processed match
   * 
   */
  public abstract void process(final AtomicEventPattern pEventPattern);
  
  @Override
  public void process(final AtomicEventPatternMatch match) {
    process(match.getEventPattern());
  }
}
