package org.eclipse.viatra.cep.core.engine.compiler.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.incquery.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.NegativePatternCall;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.viatra.cep.core.engine.compiler.AtomicEventPatternMatch;
import org.eclipse.viatra.cep.core.engine.compiler.AtomicEventPatternMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.util.TranslatedEventPatternQuerySpecification;

/**
 * A pattern-specific query specification that can instantiate AtomicEventPatternMatcher in a type-safe way.
 * 
 * @see AtomicEventPatternMatcher
 * @see AtomicEventPatternMatch
 * 
 */
@SuppressWarnings("all")
public final class AtomicEventPatternQuerySpecification extends BaseGeneratedEMFQuerySpecification<AtomicEventPatternMatcher> {
  private AtomicEventPatternQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static AtomicEventPatternQuerySpecification instance() throws IncQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected AtomicEventPatternMatcher instantiate(final IncQueryEngine engine) throws IncQueryException {
    return AtomicEventPatternMatcher.on(engine);
  }
  
  @Override
  public AtomicEventPatternMatch newEmptyMatch() {
    return AtomicEventPatternMatch.newEmptyMatch();
  }
  
  @Override
  public AtomicEventPatternMatch newMatch(final Object... parameters) {
    return AtomicEventPatternMatch.newMatch((org.eclipse.viatra.cep.core.metamodels.events.AtomicEventPattern) parameters[0]);
  }
  
  private static class LazyHolder {
    private final static AtomicEventPatternQuerySpecification INSTANCE = make();
    
    public static AtomicEventPatternQuerySpecification make() {
      return new AtomicEventPatternQuerySpecification();					
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static AtomicEventPatternQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.viatra.cep.core.engine.compiler.atomicEventPattern";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("eventPattern");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return Arrays.asList(new PParameter("eventPattern", "org.eclipse.viatra.cep.core.metamodels.events.AtomicEventPattern"));
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      	{
      		PBody body = new PBody(this);
      		PVariable var_eventPattern = body.getOrCreateVariableByName("eventPattern");
      		PVariable var___0_ = body.getOrCreateVariableByName("_<0>");
      		new TypeConstraint(body, new FlatTuple(var_eventPattern), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("cep.meta", "AtomicEventPattern")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_eventPattern, "eventPattern")
      		));
      		// 	EventModel.eventPatterns(_, eventPattern)
      		new TypeConstraint(body, new FlatTuple(var___0_), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("cep.meta", "EventModel")));
      		PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      		new TypeConstraint(body, new FlatTuple(var___0_, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("cep.meta", "EventModel", "eventPatterns")));
      		new Equality(body, var__virtual_0_, var_eventPattern);
      		// 	neg find translatedEventPattern(eventPattern)
      		new NegativePatternCall(body, new FlatTuple(var_eventPattern), TranslatedEventPatternQuerySpecification.instance().getInternalQueryRepresentation());
      		bodies.add(body);
      	}
      	// to silence compiler error
      	if (false) throw new IncQueryException("Never", "happens");
      } catch (IncQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
