package org.eclipse.viatra.cep.core.engine.compiler.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.incquery.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.NegativePatternCall;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.viatra.cep.core.engine.compiler.util.TranslatedEventPatternQuerySpecification;

/**
 * A pattern-specific query specification that can instantiate ComplexPatternMatcher in a type-safe way.
 * 
 * @see ComplexPatternMatcher
 * @see ComplexPatternMatch
 * 
 */
@SuppressWarnings("all")
final class ComplexPatternQuerySpecification extends BaseGeneratedEMFQuerySpecification<IncQueryMatcher<IPatternMatch>> {
  private ComplexPatternQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static ComplexPatternQuerySpecification instance() throws IncQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected IncQueryMatcher instantiate(final IncQueryEngine engine) throws IncQueryException {
    throw new UnsupportedOperationException();
  }
  
  @Override
  public IPatternMatch newEmptyMatch() {
    throw new UnsupportedOperationException();
  }
  
  @Override
  public IPatternMatch newMatch(final Object... parameters) {
    throw new UnsupportedOperationException();
  }
  
  private static class LazyHolder {
    private final static ComplexPatternQuerySpecification INSTANCE = make();
    
    public static ComplexPatternQuerySpecification make() {
      return new ComplexPatternQuerySpecification();					
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static ComplexPatternQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.viatra.cep.core.engine.compiler.complexPattern";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("eventPattern","operator");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return Arrays.asList(new PParameter("eventPattern", "org.eclipse.viatra.cep.core.metamodels.events.ComplexEventPattern"),new PParameter("operator", "org.eclipse.viatra.cep.core.metamodels.events.ComplexEventOperator"));
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      	{
      		PBody body = new PBody(this);
      		PVariable var_eventPattern = body.getOrCreateVariableByName("eventPattern");
      		PVariable var_operator = body.getOrCreateVariableByName("operator");
      		PVariable var___0_ = body.getOrCreateVariableByName("_<0>");
      		new TypeConstraint(body, new FlatTuple(var_eventPattern), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("cep.meta", "ComplexEventPattern")));
      		new TypeConstraint(body, new FlatTuple(var_operator), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("cep.meta", "ComplexEventOperator")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_eventPattern, "eventPattern"),
      		   new ExportedParameter(body, var_operator, "operator")
      		));
      		// 	EventModel.eventPatterns(_, eventPattern)
      		new TypeConstraint(body, new FlatTuple(var___0_), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("cep.meta", "EventModel")));
      		PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      		new TypeConstraint(body, new FlatTuple(var___0_, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("cep.meta", "EventModel", "eventPatterns")));
      		new Equality(body, var__virtual_0_, var_eventPattern);
      		// 	neg find translatedEventPattern(eventPattern)
      		new NegativePatternCall(body, new FlatTuple(var_eventPattern), TranslatedEventPatternQuerySpecification.instance().getInternalQueryRepresentation());
      		// 	ComplexEventPattern.operator(eventPattern, operator)
      		new TypeConstraint(body, new FlatTuple(var_eventPattern), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("cep.meta", "ComplexEventPattern")));
      		PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
      		new TypeConstraint(body, new FlatTuple(var_eventPattern, var__virtual_1_), new EStructuralFeatureInstancesKey(getFeatureLiteral("cep.meta", "ComplexEventPattern", "operator")));
      		new Equality(body, var__virtual_1_, var_operator);
      		bodies.add(body);
      	}
      	// to silence compiler error
      	if (false) throw new IncQueryException("Never", "happens");
      } catch (IncQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
