package org.eclipse.viatra.cep.core.engine.compiler.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.incquery.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;

/**
 * A pattern-specific query specification that can instantiate ComplexTransitionMatcher in a type-safe way.
 * 
 * @see ComplexTransitionMatcher
 * @see ComplexTransitionMatch
 * 
 */
@SuppressWarnings("all")
final class ComplexTransitionQuerySpecification extends BaseGeneratedEMFQuerySpecification<IncQueryMatcher<IPatternMatch>> {
  private ComplexTransitionQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static ComplexTransitionQuerySpecification instance() throws IncQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected IncQueryMatcher instantiate(final IncQueryEngine engine) throws IncQueryException {
    throw new UnsupportedOperationException();
  }
  
  @Override
  public IPatternMatch newEmptyMatch() {
    throw new UnsupportedOperationException();
  }
  
  @Override
  public IPatternMatch newMatch(final Object... parameters) {
    throw new UnsupportedOperationException();
  }
  
  private static class LazyHolder {
    private final static ComplexTransitionQuerySpecification INSTANCE = make();
    
    public static ComplexTransitionQuerySpecification make() {
      return new ComplexTransitionQuerySpecification();					
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static ComplexTransitionQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.viatra.cep.core.engine.compiler.complexTransition";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("automaton","transition","eventPattern","operator");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return Arrays.asList(new PParameter("automaton", "org.eclipse.viatra.cep.core.metamodels.automaton.Automaton"),new PParameter("transition", "org.eclipse.viatra.cep.core.metamodels.automaton.TypedTransition"),new PParameter("eventPattern", "org.eclipse.viatra.cep.core.metamodels.events.ComplexEventPattern"),new PParameter("operator", "org.eclipse.viatra.cep.core.metamodels.events.ComplexEventOperator"));
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      	{
      		PBody body = new PBody(this);
      		PVariable var_automaton = body.getOrCreateVariableByName("automaton");
      		PVariable var_transition = body.getOrCreateVariableByName("transition");
      		PVariable var_eventPattern = body.getOrCreateVariableByName("eventPattern");
      		PVariable var_operator = body.getOrCreateVariableByName("operator");
      		PVariable var_preState = body.getOrCreateVariableByName("preState");
      		PVariable var_postState = body.getOrCreateVariableByName("postState");
      		PVariable var_guard = body.getOrCreateVariableByName("guard");
      		new TypeConstraint(body, new FlatTuple(var_automaton), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "Automaton")));
      		new TypeConstraint(body, new FlatTuple(var_transition), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "TypedTransition")));
      		new TypeConstraint(body, new FlatTuple(var_eventPattern), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("cep.meta", "ComplexEventPattern")));
      		new TypeConstraint(body, new FlatTuple(var_operator), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("cep.meta", "ComplexEventOperator")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_automaton, "automaton"),
      		   new ExportedParameter(body, var_transition, "transition"),
      		   new ExportedParameter(body, var_eventPattern, "eventPattern"),
      		   new ExportedParameter(body, var_operator, "operator")
      		));
      		// 	Automaton.states(automaton, preState)
      		new TypeConstraint(body, new FlatTuple(var_automaton), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "Automaton")));
      		PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      		new TypeConstraint(body, new FlatTuple(var_automaton, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "Automaton", "states")));
      		new Equality(body, var__virtual_0_, var_preState);
      		// 	Automaton.states(automaton, postState)
      		new TypeConstraint(body, new FlatTuple(var_automaton), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "Automaton")));
      		PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
      		new TypeConstraint(body, new FlatTuple(var_automaton, var__virtual_1_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "Automaton", "states")));
      		new Equality(body, var__virtual_1_, var_postState);
      		// 	State.outTransitions(preState, transition)
      		new TypeConstraint(body, new FlatTuple(var_preState), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "State")));
      		PVariable var__virtual_2_ = body.getOrCreateVariableByName(".virtual{2}");
      		new TypeConstraint(body, new FlatTuple(var_preState, var__virtual_2_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "State", "outTransitions")));
      		new Equality(body, var__virtual_2_, var_transition);
      		// 	State.inTransitions(postState, transition)
      		new TypeConstraint(body, new FlatTuple(var_postState), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "State")));
      		PVariable var__virtual_3_ = body.getOrCreateVariableByName(".virtual{3}");
      		new TypeConstraint(body, new FlatTuple(var_postState, var__virtual_3_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "State", "inTransitions")));
      		new Equality(body, var__virtual_3_, var_transition);
      		// 	TypedTransition.guards(transition, guard)
      		new TypeConstraint(body, new FlatTuple(var_transition), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "TypedTransition")));
      		PVariable var__virtual_4_ = body.getOrCreateVariableByName(".virtual{4}");
      		new TypeConstraint(body, new FlatTuple(var_transition, var__virtual_4_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "TypedTransition", "guards")));
      		new Equality(body, var__virtual_4_, var_guard);
      		// 	Guard.eventType(guard, eventPattern)
      		new TypeConstraint(body, new FlatTuple(var_guard), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "Guard")));
      		PVariable var__virtual_5_ = body.getOrCreateVariableByName(".virtual{5}");
      		new TypeConstraint(body, new FlatTuple(var_guard, var__virtual_5_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "Guard", "eventType")));
      		new Equality(body, var__virtual_5_, var_eventPattern);
      		// 	ComplexEventPattern.operator(eventPattern, operator)
      		new TypeConstraint(body, new FlatTuple(var_eventPattern), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("cep.meta", "ComplexEventPattern")));
      		PVariable var__virtual_6_ = body.getOrCreateVariableByName(".virtual{6}");
      		new TypeConstraint(body, new FlatTuple(var_eventPattern, var__virtual_6_), new EStructuralFeatureInstancesKey(getFeatureLiteral("cep.meta", "ComplexEventPattern", "operator")));
      		new Equality(body, var__virtual_6_, var_operator);
      		bodies.add(body);
      	}
      	// to silence compiler error
      	if (false) throw new IncQueryException("Never", "happens");
      } catch (IncQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
