package org.eclipse.viatra.cep.core.engine.compiler.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.viatra.cep.core.engine.compiler.EpsilonTransitionMatch;
import org.eclipse.viatra.cep.core.metamodels.automaton.Automaton;
import org.eclipse.viatra.cep.core.metamodels.automaton.EpsilonTransition;
import org.eclipse.viatra.cep.core.metamodels.automaton.State;

/**
 * A match processor tailored for the org.eclipse.viatra.cep.core.engine.compiler.epsilonTransition pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class EpsilonTransitionProcessor implements IMatchProcessor<EpsilonTransitionMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pAutomaton the value of pattern parameter automaton in the currently processed match
   * @param pTransition the value of pattern parameter transition in the currently processed match
   * @param pPreState the value of pattern parameter preState in the currently processed match
   * @param pPostState the value of pattern parameter postState in the currently processed match
   * 
   */
  public abstract void process(final Automaton pAutomaton, final EpsilonTransition pTransition, final State pPreState, final State pPostState);
  
  @Override
  public void process(final EpsilonTransitionMatch match) {
    process(match.getAutomaton(), match.getTransition(), match.getPreState(), match.getPostState());
  }
}
