package org.eclipse.viatra.cep.core.engine.compiler.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.incquery.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.viatra.cep.core.engine.compiler.EpsilonTransitionMatch;
import org.eclipse.viatra.cep.core.engine.compiler.EpsilonTransitionMatcher;

/**
 * A pattern-specific query specification that can instantiate EpsilonTransitionMatcher in a type-safe way.
 * 
 * @see EpsilonTransitionMatcher
 * @see EpsilonTransitionMatch
 * 
 */
@SuppressWarnings("all")
public final class EpsilonTransitionQuerySpecification extends BaseGeneratedEMFQuerySpecification<EpsilonTransitionMatcher> {
  private EpsilonTransitionQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static EpsilonTransitionQuerySpecification instance() throws IncQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected EpsilonTransitionMatcher instantiate(final IncQueryEngine engine) throws IncQueryException {
    return EpsilonTransitionMatcher.on(engine);
  }
  
  @Override
  public EpsilonTransitionMatch newEmptyMatch() {
    return EpsilonTransitionMatch.newEmptyMatch();
  }
  
  @Override
  public EpsilonTransitionMatch newMatch(final Object... parameters) {
    return EpsilonTransitionMatch.newMatch((org.eclipse.viatra.cep.core.metamodels.automaton.Automaton) parameters[0], (org.eclipse.viatra.cep.core.metamodels.automaton.EpsilonTransition) parameters[1], (org.eclipse.viatra.cep.core.metamodels.automaton.State) parameters[2], (org.eclipse.viatra.cep.core.metamodels.automaton.State) parameters[3]);
  }
  
  private static class LazyHolder {
    private final static EpsilonTransitionQuerySpecification INSTANCE = make();
    
    public static EpsilonTransitionQuerySpecification make() {
      return new EpsilonTransitionQuerySpecification();					
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static EpsilonTransitionQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.viatra.cep.core.engine.compiler.epsilonTransition";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("automaton","transition","preState","postState");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return Arrays.asList(new PParameter("automaton", "org.eclipse.viatra.cep.core.metamodels.automaton.Automaton"),new PParameter("transition", "org.eclipse.viatra.cep.core.metamodels.automaton.EpsilonTransition"),new PParameter("preState", "org.eclipse.viatra.cep.core.metamodels.automaton.State"),new PParameter("postState", "org.eclipse.viatra.cep.core.metamodels.automaton.State"));
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      	{
      		PBody body = new PBody(this);
      		PVariable var_automaton = body.getOrCreateVariableByName("automaton");
      		PVariable var_transition = body.getOrCreateVariableByName("transition");
      		PVariable var_preState = body.getOrCreateVariableByName("preState");
      		PVariable var_postState = body.getOrCreateVariableByName("postState");
      		new TypeConstraint(body, new FlatTuple(var_automaton), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "Automaton")));
      		new TypeConstraint(body, new FlatTuple(var_transition), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "EpsilonTransition")));
      		new TypeConstraint(body, new FlatTuple(var_preState), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "State")));
      		new TypeConstraint(body, new FlatTuple(var_postState), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "State")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_automaton, "automaton"),
      		   new ExportedParameter(body, var_transition, "transition"),
      		   new ExportedParameter(body, var_preState, "preState"),
      		   new ExportedParameter(body, var_postState, "postState")
      		));
      		// 	Automaton.states(automaton, preState)
      		new TypeConstraint(body, new FlatTuple(var_automaton), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "Automaton")));
      		PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      		new TypeConstraint(body, new FlatTuple(var_automaton, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "Automaton", "states")));
      		new Equality(body, var__virtual_0_, var_preState);
      		// 	Automaton.states(automaton, postState)
      		new TypeConstraint(body, new FlatTuple(var_automaton), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "Automaton")));
      		PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
      		new TypeConstraint(body, new FlatTuple(var_automaton, var__virtual_1_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "Automaton", "states")));
      		new Equality(body, var__virtual_1_, var_postState);
      		// 	State.outTransitions(preState, transition)
      		new TypeConstraint(body, new FlatTuple(var_preState), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "State")));
      		PVariable var__virtual_2_ = body.getOrCreateVariableByName(".virtual{2}");
      		new TypeConstraint(body, new FlatTuple(var_preState, var__virtual_2_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "State", "outTransitions")));
      		new Equality(body, var__virtual_2_, var_transition);
      		// 	State.inTransitions(postState, transition)
      		new TypeConstraint(body, new FlatTuple(var_postState), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "State")));
      		PVariable var__virtual_3_ = body.getOrCreateVariableByName(".virtual{3}");
      		new TypeConstraint(body, new FlatTuple(var_postState, var__virtual_3_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "State", "inTransitions")));
      		new Equality(body, var__virtual_3_, var_transition);
      		bodies.add(body);
      	}
      	// to silence compiler error
      	if (false) throw new IncQueryException("Never", "happens");
      } catch (IncQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
