package org.eclipse.viatra.cep.core.engine.compiler.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.viatra.cep.core.engine.compiler.EquivalentStatesMatch;
import org.eclipse.viatra.cep.core.metamodels.automaton.State;
import org.eclipse.viatra.cep.core.metamodels.automaton.TypedTransition;

/**
 * A match processor tailored for the org.eclipse.viatra.cep.core.engine.compiler.equivalentStates pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class EquivalentStatesProcessor implements IMatchProcessor<EquivalentStatesMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pTransition1 the value of pattern parameter transition1 in the currently processed match
   * @param pTransition2 the value of pattern parameter transition2 in the currently processed match
   * @param pPreState the value of pattern parameter preState in the currently processed match
   * @param pPostState1 the value of pattern parameter postState1 in the currently processed match
   * @param pPostState2 the value of pattern parameter postState2 in the currently processed match
   * 
   */
  public abstract void process(final TypedTransition pTransition1, final TypedTransition pTransition2, final State pPreState, final State pPostState1, final State pPostState2);
  
  @Override
  public void process(final EquivalentStatesMatch match) {
    process(match.getTransition1(), match.getTransition2(), match.getPreState(), match.getPostState1(), match.getPostState2());
  }
}
