package org.eclipse.viatra.cep.core.engine.compiler.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.incquery.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Inequality;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.viatra.cep.core.engine.compiler.EquivalentStatesMatch;
import org.eclipse.viatra.cep.core.engine.compiler.EquivalentStatesMatcher;
import org.eclipse.viatra.cep.core.engine.compiler.util.SameBooleanTransitionTypeQuerySpecification;

/**
 * A pattern-specific query specification that can instantiate EquivalentStatesMatcher in a type-safe way.
 * 
 * @see EquivalentStatesMatcher
 * @see EquivalentStatesMatch
 * 
 */
@SuppressWarnings("all")
public final class EquivalentStatesQuerySpecification extends BaseGeneratedEMFQuerySpecification<EquivalentStatesMatcher> {
  private EquivalentStatesQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static EquivalentStatesQuerySpecification instance() throws IncQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected EquivalentStatesMatcher instantiate(final IncQueryEngine engine) throws IncQueryException {
    return EquivalentStatesMatcher.on(engine);
  }
  
  @Override
  public EquivalentStatesMatch newEmptyMatch() {
    return EquivalentStatesMatch.newEmptyMatch();
  }
  
  @Override
  public EquivalentStatesMatch newMatch(final Object... parameters) {
    return EquivalentStatesMatch.newMatch((org.eclipse.viatra.cep.core.metamodels.automaton.TypedTransition) parameters[0], (org.eclipse.viatra.cep.core.metamodels.automaton.TypedTransition) parameters[1], (org.eclipse.viatra.cep.core.metamodels.automaton.State) parameters[2], (org.eclipse.viatra.cep.core.metamodels.automaton.State) parameters[3], (org.eclipse.viatra.cep.core.metamodels.automaton.State) parameters[4]);
  }
  
  private static class LazyHolder {
    private final static EquivalentStatesQuerySpecification INSTANCE = make();
    
    public static EquivalentStatesQuerySpecification make() {
      return new EquivalentStatesQuerySpecification();					
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static EquivalentStatesQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.viatra.cep.core.engine.compiler.equivalentStates";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("transition1","transition2","preState","postState1","postState2");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return Arrays.asList(new PParameter("transition1", "org.eclipse.viatra.cep.core.metamodels.automaton.TypedTransition"),new PParameter("transition2", "org.eclipse.viatra.cep.core.metamodels.automaton.TypedTransition"),new PParameter("preState", "org.eclipse.viatra.cep.core.metamodels.automaton.State"),new PParameter("postState1", "org.eclipse.viatra.cep.core.metamodels.automaton.State"),new PParameter("postState2", "org.eclipse.viatra.cep.core.metamodels.automaton.State"));
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      	{
      		PBody body = new PBody(this);
      		PVariable var_transition1 = body.getOrCreateVariableByName("transition1");
      		PVariable var_transition2 = body.getOrCreateVariableByName("transition2");
      		PVariable var_preState = body.getOrCreateVariableByName("preState");
      		PVariable var_postState1 = body.getOrCreateVariableByName("postState1");
      		PVariable var_postState2 = body.getOrCreateVariableByName("postState2");
      		PVariable var_guard1 = body.getOrCreateVariableByName("guard1");
      		PVariable var_guard2 = body.getOrCreateVariableByName("guard2");
      		PVariable var_et1 = body.getOrCreateVariableByName("et1");
      		PVariable var_et2 = body.getOrCreateVariableByName("et2");
      		PVariable var_automaton = body.getOrCreateVariableByName("automaton");
      		new TypeConstraint(body, new FlatTuple(var_transition1), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "TypedTransition")));
      		new TypeConstraint(body, new FlatTuple(var_transition2), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "TypedTransition")));
      		new TypeConstraint(body, new FlatTuple(var_preState), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "State")));
      		new TypeConstraint(body, new FlatTuple(var_postState1), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "State")));
      		new TypeConstraint(body, new FlatTuple(var_postState2), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "State")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_transition1, "transition1"),
      		   new ExportedParameter(body, var_transition2, "transition2"),
      		   new ExportedParameter(body, var_preState, "preState"),
      		   new ExportedParameter(body, var_postState1, "postState1"),
      		   new ExportedParameter(body, var_postState2, "postState2")
      		));
      		// 	transition1 != transition2
      		new Inequality(body, var_transition1, var_transition2);
      		// 		find sameBooleanTransitionType(transition1, transition2)
      		new PositivePatternCall(body, new FlatTuple(var_transition1, var_transition2), SameBooleanTransitionTypeQuerySpecification.instance().getInternalQueryRepresentation());
      		// 	Transition.preState(transition1, preState)
      		new TypeConstraint(body, new FlatTuple(var_transition1), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "Transition")));
      		PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      		new TypeConstraint(body, new FlatTuple(var_transition1, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "Transition", "preState")));
      		new Equality(body, var__virtual_0_, var_preState);
      		// 	Transition.preState(transition2, preState)
      		new TypeConstraint(body, new FlatTuple(var_transition2), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "Transition")));
      		PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
      		new TypeConstraint(body, new FlatTuple(var_transition2, var__virtual_1_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "Transition", "preState")));
      		new Equality(body, var__virtual_1_, var_preState);
      		// 	Transition.postState(transition1, postState1)
      		new TypeConstraint(body, new FlatTuple(var_transition1), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "Transition")));
      		PVariable var__virtual_2_ = body.getOrCreateVariableByName(".virtual{2}");
      		new TypeConstraint(body, new FlatTuple(var_transition1, var__virtual_2_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "Transition", "postState")));
      		new Equality(body, var__virtual_2_, var_postState1);
      		// 	Transition.postState(transition2, postState2)
      		new TypeConstraint(body, new FlatTuple(var_transition2), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "Transition")));
      		PVariable var__virtual_3_ = body.getOrCreateVariableByName(".virtual{3}");
      		new TypeConstraint(body, new FlatTuple(var_transition2, var__virtual_3_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "Transition", "postState")));
      		new Equality(body, var__virtual_3_, var_postState2);
      		// 	postState1 != postState2
      		new Inequality(body, var_postState1, var_postState2);
      		// 	TypedTransition.guards(transition1, guard1)
      		new TypeConstraint(body, new FlatTuple(var_transition1), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "TypedTransition")));
      		PVariable var__virtual_4_ = body.getOrCreateVariableByName(".virtual{4}");
      		new TypeConstraint(body, new FlatTuple(var_transition1, var__virtual_4_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "TypedTransition", "guards")));
      		new Equality(body, var__virtual_4_, var_guard1);
      		// 	TypedTransition.guards(transition2, guard2)
      		new TypeConstraint(body, new FlatTuple(var_transition2), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "TypedTransition")));
      		PVariable var__virtual_5_ = body.getOrCreateVariableByName(".virtual{5}");
      		new TypeConstraint(body, new FlatTuple(var_transition2, var__virtual_5_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "TypedTransition", "guards")));
      		new Equality(body, var__virtual_5_, var_guard2);
      		// 	Guard.eventType(guard1, et1)
      		new TypeConstraint(body, new FlatTuple(var_guard1), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "Guard")));
      		PVariable var__virtual_6_ = body.getOrCreateVariableByName(".virtual{6}");
      		new TypeConstraint(body, new FlatTuple(var_guard1, var__virtual_6_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "Guard", "eventType")));
      		new Equality(body, var__virtual_6_, var_et1);
      		// 	Guard.eventType(guard2, et2)
      		new TypeConstraint(body, new FlatTuple(var_guard2), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "Guard")));
      		PVariable var__virtual_7_ = body.getOrCreateVariableByName(".virtual{7}");
      		new TypeConstraint(body, new FlatTuple(var_guard2, var__virtual_7_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "Guard", "eventType")));
      		new Equality(body, var__virtual_7_, var_et2);
      		// 	et1 == et2
      		new Equality(body, var_et1, var_et2);
      		// 	Automaton.states(automaton, preState)
      		new TypeConstraint(body, new FlatTuple(var_automaton), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "Automaton")));
      		PVariable var__virtual_8_ = body.getOrCreateVariableByName(".virtual{8}");
      		new TypeConstraint(body, new FlatTuple(var_automaton, var__virtual_8_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "Automaton", "states")));
      		new Equality(body, var__virtual_8_, var_preState);
      		// 	Automaton.states(automaton, postState1)
      		new TypeConstraint(body, new FlatTuple(var_automaton), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "Automaton")));
      		PVariable var__virtual_9_ = body.getOrCreateVariableByName(".virtual{9}");
      		new TypeConstraint(body, new FlatTuple(var_automaton, var__virtual_9_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "Automaton", "states")));
      		new Equality(body, var__virtual_9_, var_postState1);
      		// 	Automaton.states(automaton, postState2)
      		new TypeConstraint(body, new FlatTuple(var_automaton), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("automaton.meta", "Automaton")));
      		PVariable var__virtual_10_ = body.getOrCreateVariableByName(".virtual{10}");
      		new TypeConstraint(body, new FlatTuple(var_automaton, var__virtual_10_), new EStructuralFeatureInstancesKey(getFeatureLiteral("automaton.meta", "Automaton", "states")));
      		new Equality(body, var__virtual_10_, var_postState2);
      		bodies.add(body);
      	}
      	// to silence compiler error
      	if (false) throw new IncQueryException("Never", "happens");
      } catch (IncQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
